<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: ../admin-login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Blog Admin Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f4f6f9;
    }
    .sidebar {
      background: linear-gradient(180deg, #0d6efd, #6610f2);
      min-height: 100vh;
      color: #fff;
    }
    .sidebar .nav-link {
      color: #ddd;
      border-radius: 8px;
      margin: 4px 0;
      padding: 10px 15px;
      transition: all 0.3s ease;
    }
    .sidebar .nav-link:hover,
    .sidebar .nav-link.active {
      background: rgba(255, 255, 255, 0.2);
      color: #fff;
    }
    .card {
      border: none;
      border-radius: 16px;
      transition: all 0.3s ease;
    }
    .card-hover:hover {
      transform: translateY(-6px);
      box-shadow: 0 12px 25px rgba(0,0,0,0.15);
    }
    .navbar {
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
  </style>
</head>
<body>

<!-- Top Navbar (for mobile toggle) -->
<nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top d-lg-none">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold text-primary" href="#">Blog Admin</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar">
      <span class="navbar-toggler-icon"></span>
    </button>
  </div>
</nav>

<div class="container-fluid">
  <div class="row">
    
    <?php include("sidebar.php"); ?>

    <!-- Main Content -->
    <main class="col-lg-10 ms-auto px-4 py-4">
      <h2 class="mb-4">Welcome back, Admin!</h2>
      <div class="row g-4">
        <div class="col-md-6 col-lg-3">
          <div class="card card-hover shadow-sm text-center p-3">
            <i class="fas fa-pen fa-2x text-primary mb-2"></i>
            <h5>Create Post</h5>
            <p class="text-muted">Write and publish articles.</p>
          </div>
        </div>
        <div class="col-md-6 col-lg-3">
          <div class="card card-hover shadow-sm text-center p-3">
            <i class="fas fa-edit fa-2x text-success mb-2"></i>
            <h5>Manage Posts</h5>
            <p class="text-muted">Update or delete content.</p>
          </div>
        </div>
        
        <!--
        <div class="col-md-6 col-lg-3">
          <div class="card card-hover shadow-sm text-center p-3">
            <i class="fas fa-comments fa-2x text-warning mb-2"></i>
            <h5>Comments</h5>
            <p class="text-muted">Review user feedback.</p>
          </div>
        </div>
        <div class="col-md-6 col-lg-3">
          <div class="card card-hover shadow-sm text-center p-3">
            <i class="fas fa-users fa-2x text-danger mb-2"></i>
            <h5>Users</h5>
            <p class="text-muted">Manage blog members.</p>
          </div>
        </div>
        -->
      </div>
    </main>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
