<?php
// manage-posts.php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include "../connection.php"; // DB connection ($conn)

// ✅ Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $sql = "DELETE FROM posts WHERE id = $id";
    mysqli_query($conn, $sql);
    header("Location: manage-posts.php?msg=deleted");
    exit;
}

// ✅ Fetch posts
$result = mysqli_query($conn, "SELECT * FROM posts ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Manage Blog Posts</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f4f6f9;
    }
    .sidebar {
      background: linear-gradient(180deg, #0d6efd, #6610f2);
      min-height: 100vh;
      color: #fff;
    }
    .sidebar .nav-link {
      color: #ddd;
      border-radius: 8px;
      margin: 4px 0;
      padding: 10px 15px;
      transition: all 0.3s ease;
    }
    .sidebar .nav-link:hover,
    .sidebar .nav-link.active {
      background: rgba(255, 255, 255, 0.2);
      color: #fff;
    }
    .navbar {
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    .thumbnail-img {
      width: 60px;
      height: 60px;
      object-fit: cover;
      border-radius: 6px;
    }
  </style>
</head>
<body>

<!-- Top Navbar (for mobile toggle) -->
<nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top d-lg-none">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold text-primary" href="#">Blog Admin</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar">
      <span class="navbar-toggler-icon"></span>
    </button>
  </div>
</nav>

<div class="container-fluid">
  <div class="row">
    
    <?php include("sidebar.php"); ?>

    <!-- Main Content -->
    <main class="col-lg-10 ms-auto px-4 py-4" style="background-color: white;">
      <h2 class="mb-4 text-primary">📑 Manage Blog Posts</h2>

      <?php if (!empty($_GET['msg']) && $_GET['msg'] === 'deleted'): ?>
        <div class="alert alert-success">✅ Post deleted successfully!</div>
      <?php endif; ?>

      <div class="table-responsive">
        <table class="table table-bordered align-middle">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th>Thumbnail</th>
              <th>Title</th>
              <th>Created At</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php while ($row = mysqli_fetch_assoc($result)): ?>
              <tr>
                <td><?= $row['id']; ?></td>
                <td>
                  <?php if ($row['thumbnail']): ?>
                    <img src="<?= $row['thumbnail']; ?>" class="thumbnail-img">
                  <?php else: ?>
                    <span class="text-muted">No Image</span>
                  <?php endif; ?>
                </td>
                <td><?= htmlspecialchars($row['title']); ?></td>
                <td><?= $row['created_at']; ?></td>
                <td>
                  <a href="edit-post.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-warning"><i class="fa fa-edit"></i> Edit</a>
                  <a href="manage-posts.php?delete=<?= $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this post?');">
                    <i class="fa fa-trash"></i> Delete
                  </a>
                </td>
              </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </main>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
