<?php
include("connection.php");

// Track unique visitors
$ip = $_SERVER['REMOTE_ADDR']; 
$date = date("Y-m-d");

// Check if this IP has already been counted today
$checkVisitor = $conn->query("SELECT * FROM visitors WHERE ip_address = '$ip' AND visit_date = '$date'");

if ($checkVisitor->num_rows == 0) {
    // New unique visitor for today
    $conn->query("INSERT INTO visitors (ip_address, visit_date) VALUES ('$ip', '$date')");
}


// Pagination setup
$limit = 6; // posts per page
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Search setup
$search = isset($_GET['search']) ? trim($_GET['search']) : "";
$whereClause = "";
if ($search !== "") {
  $safeSearch = $conn->real_escape_string($search);
  $whereClause = "WHERE title LIKE '%$safeSearch%' OR description LIKE '%$safeSearch%'";
}

// Count total posts
$totalQuery = $conn->query("SELECT COUNT(*) AS total FROM posts $whereClause");
$totalRow = $totalQuery->fetch_assoc();
$totalPosts = $totalRow['total'];
$totalPages = ceil($totalPosts / $limit);

// Fetch posts for grid
$postsQuery = $conn->query("SELECT * FROM posts $whereClause ORDER BY created_at DESC LIMIT $limit OFFSET $offset");
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Uncommon Learning Standard - Simplifying Knowledge For Curious Minds</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="logo.png" rel="icon">
  <link href="logo.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&family=EB+Garamond:ital,wght@0,400;0,500;0,600;0,700;0,800;1,400;1,500;1,600;1,700;1,800&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">

  <style>
    /* ✅ Fixed height slider */
    .slider .swiper-slide {
      height: 400px; /* Adjust as needed */
      background-size: cover;
      background-position: center;
      position: relative;
      display: flex;
      align-items: flex-end;
    }

    .slider .swiper-slide .content {
      background: rgba(0, 0, 0, 0.5);
      color: #fff;
      padding: 20px;
      width: 100%;
    }

    /* ✅ Limit description to 4 lines */
    .slider .swiper-slide .content p {
      display: -webkit-box;
      -webkit-line-clamp: 4;
      -webkit-box-orient: vertical;
      overflow: hidden;
      text-overflow: ellipsis;
      margin: 0;
    }
    
    .page-link{
        background-color: black;
        border: none;
    }
  </style>
</head>

<body class="index-page">

  <?php include("header.php"); ?>

  <main class="main">

    <!-- Slider Section -->
    <section id="slider" class="slider section dark-background">
      <div class="container" data-aos="fade-up" data-aos-delay="100">
        <div class="swiper init-swiper">

          <script type="application/json" class="swiper-config">
            {
              "loop": true,
              "speed": 600,
              "autoplay": { "delay": 5000 },
              "slidesPerView": "auto",
              "centeredSlides": true,
              "pagination": { "el": ".swiper-pagination", "type": "bullets", "clickable": true },
              "navigation": { "nextEl": ".swiper-button-next", "prevEl": ".swiper-button-prev" }
            }
          </script>

          <div class="swiper-wrapper">
            <?php
            $sliderQuery = $conn->query("SELECT * FROM posts ORDER BY created_at DESC LIMIT 4");
            while ($row = $sliderQuery->fetch_assoc()) {
              echo '<div class="swiper-slide" style="background-image: url(admin/' . htmlspecialchars($row['thumbnail']) . ');">
                      <div class="content">
                        <h2><a href="single-post.php?id=' . $row['id'] . '" style="color: #fff; text-decoration: none;">' . htmlspecialchars($row['title']) . '</a></h2>
                        <p>' . strip_tags($row['description']) . '</p>
                      </div>
                    </div>';
            }
            ?>
          </div>

          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
          <div class="swiper-pagination"></div>
        </div>
      </div>
    </section>
    <!-- /Slider Section -->

    <!-- Trending Category Section -->
    <section id="trending-category" class="trending-category section">
      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <!-- Search Bar -->
        <form method="get" class="mb-4">
          <div class="input-group">
            <input type="text" name="search" class="form-control" placeholder="Search posts..." value="<?php echo htmlspecialchars($search); ?>">
            <button class="btn btn-primary" type="submit" style="background-color: black; border: none;"><i class="bi bi-search"></i></button>
          </div>
        </form>

        <div class="row g-5">
          <?php
          if ($postsQuery->num_rows > 0) {
            while ($post = $postsQuery->fetch_assoc()) {
              echo '<div class="col-lg-4">
                      <div class="post-entry">
                        <a href="single-post.php?id=' . $post['id'] . '"><img src="admin/' . htmlspecialchars($post['thumbnail']) . '" alt="" class="img-fluid"></a>
                        <div class="post-meta"><span>' . date("M j, Y", strtotime($post['created_at'])) . '</span></div>
                        <h2><a href="single-post.php?id=' . $post['id'] . '">' . htmlspecialchars($post['title']) . '</a></h2>
                      </div>
                    </div>';
            }
          } else {
            echo "<p>No posts found.</p>";
          }
          ?>
        </div>

        <!-- Pagination -->
        <nav aria-label="Page navigation" class="mt-4">
          <ul class="pagination justify-content-center">
            <?php if ($page > 1): ?>
              <li class="page-item">
                <a class="page-link" href="?page=<?php echo $page - 1; ?>&search=<?php echo urlencode($search); ?>">Previous</a>
              </li>
            <?php endif; ?>

            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
              <li class="page-item <?php if ($i == $page) echo 'active'; ?>">
                <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>"><?php echo $i; ?></a>
              </li>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
              <li class="page-item">
                <a class="page-link" href="?page=<?php echo $page + 1; ?>&search=<?php echo urlencode($search); ?>">Next</a>
              </li>
            <?php endif; ?>
          </ul>
        </nav>

      </div>
    </section>
    <!-- /Trending Category Section -->

  </main>

  <?php include("footer.php"); ?>

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center">
    <i class="bi bi-arrow-up-short"></i>
  </a>

  <!-- Preloader -->
  <div id="preloader"></div>

  <!-- Vendor JS Files -->
  <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/vendor/php-email-form/validate.js"></script>
  <script src="assets/vendor/aos/aos.js"></script>
  <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>

</body>
</html>
