<?php  
session_start();
error_reporting(0);
include 'header.php';
?>

<!-- begin #content -->
<div id="content" class="content">
    <h1 class="page-header mb-3"><i class="fas fa-id-card"></i> KYC Verification</h1>

    <?php  
    if (isset($_POST['save_kyc'])) {
        $full_name   = mysqli_real_escape_string($link, $_POST['full_name']);
        $dob         = mysqli_real_escape_string($link, $_POST['dob']);
        $address     = mysqli_real_escape_string($link, $_POST['address']);
        $id_type     = mysqli_real_escape_string($link, $_POST['id_type']);
        $id_number   = mysqli_real_escape_string($link, $_POST['id_number']);

        // Handle file upload
        $file_name = "";
        if (!empty($_FILES['id_file']['name'])) {
            $file_name = time() . "_" . basename($_FILES['id_file']['name']);
            $target = "uploads/kyc/" . $file_name;
            if (!is_dir("uploads/kyc")) {
                mkdir("uploads/kyc", 0777, true);
            }
            move_uploaded_file($_FILES['id_file']['tmp_name'], $target);
        }

        // Insert into kyc_table with default status = 'pending'
        $query = "INSERT INTO kyc_table (user_id, full_name, dob, address, id_type, id_number, id_file, status, created_at) 
                  VALUES ('$uid','$full_name','$dob','$address','$id_type','$id_number','$file_name','pending', NOW())";
        if (mysqli_query($link, $query)) {
            echo '<div class="alert alert-success">KYC details submitted successfully. Status: Pending review.</div>';
        } else {
            echo '<div class="alert alert-danger">Error: ' . mysqli_error($link) . '</div>';
        }
    }
    ?>

    <div class="row">
        <div class="col-xl-8 col-12">
            <div class="panel panel-inverse">
                <div class="panel-heading">
                    <h4 class="panel-title">Enter Your KYC Details</h4>
                </div>
                <div class="panel-body">
                    <form method="post" enctype="multipart/form-data">
                        <div class="form-group mb-3">
                            <label>Full Name</label>
                            <input type="text" name="full_name" class="form-control" required>
                        </div>

                        <div class="form-group mb-3">
                            <label>Date of Birth</label>
                            <input type="date" name="dob" class="form-control" required>
                        </div>

                        <div class="form-group mb-3">
                            <label>Address</label>
                            <textarea name="address" class="form-control" rows="3" required></textarea>
                        </div>

                        <div class="form-group mb-3">
                            <label>ID Type</label>
                            <select name="id_type" class="form-control" required>
                                <option value="">-- Select ID Type --</option>
                                <option value="Passport">Passport</option>
                                <option value="Driver License">Driver License</option>
                                <option value="National ID">National ID</option>
                                <option value="Voter Card">Voter Card</option>
                            </select>
                        </div>

                        <div class="form-group mb-3">
                            <label>ID Number</label>
                            <input type="text" name="id_number" class="form-control" required>
                        </div>

                        <div class="form-group mb-3">
                            <label>Upload ID Document</label>
                            <input type="file" name="id_file" class="form-control" accept="image/*,.pdf" required>
                        </div>

                        <div class="text-center">
                            <button type="submit" name="save_kyc" class="btn btn-lg btn-teal">Submit KYC</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php  
include 'footer.php';
?>
