<?php
// Include the header file
include 'header.php';

// Check if the form has been submitted
if (isset($_POST['submit'])) {
    // Sanitize and retrieve the amount from the form
    $amount = text_input($_POST['amount']);
    
    // Check if the amount is empty
    if (empty($amount)) {
        echo "<script>alert('Enter Amount');</script>";
    } 
    // Check if the amount is invalid (less than or equal to 0)
    elseif ($amount <= 0) {
        echo "<script>alert('Invalid Amount');</script>";
    } 
    // Check if the amount exceeds the available funds
    elseif ($amount > $profit) {
        echo "<script>alert('Insufficient Funds');</script>";
    } else {
        // Sanitize and retrieve other form inputs
        $wallet = text_input($_POST['wallet']);
        $method = text_input($_POST['method']);
        $status = "PENDING";
        $date = date('d-m-Y H:i'); // Get the current date and time
        
        // SQL statement to update account balance by deducting the withdrawal amount
        $update_balance_sql = "UPDATE account_balance SET account_balance = account_balance - $amount WHERE username = '$username' ORDER BY id DESC LIMIT 1";
        
        // Execute the SQL statement to update account balance
        $update_balance_query = mysqli_query($link, $update_balance_sql);
        
        // Check if the balance update was successful
        if ($update_balance_query) {
            // Insert the withdrawal request into the database
            $insert = mysqli_query($link, "INSERT INTO withdrawals (`userId`, `amount`, `wallet`, `method`, `status`, `date`) 
                                            VALUES ('$uid', '$amount', '$wallet', '$method', '$status', '$date')");
            
            // Check if the insertion was successful
            if ($insert) {
                // Send email notification to the user
                $subject = "Withdrawal Alert";
                $body = "<p>Dear ".$name."</p><p>Your withdrawal request of $".$amount." has been sent. Your chosen wallet will be credited once it is approved.</p>";
                sendMail($email, $subject, $body);
                
                // Display success message and redirect after a delay
                echo "<script>alert('Your withdrawal request has been sent and is awaiting confirmation'); setTimeout(function(){ window.location.href = 'withdraw_history.php'; }, 2000);</script>";
            } else {
                // Display an alert if the insertion failed
                echo "<script>alert('Failed to submit withdrawal request. Please try again later.');</script>";
            }
        } else {
            // Display an alert if updating the balance failed
            echo "<script>alert('Failed to update account balance. Please try again later.');</script>";
        }
    }
}
?>





<!-- end #sidebar --> <!-- begin #content -->
    <div id="content" class="content">
      <!-- begin breadcrumb -->
      <!-- end breadcrumb -->
      <!-- begin page-header -->
      <h1 class="page-header mb-3"><i class="far fa-money-bill-alt"></i> Withdrawal</h1>
      <!-- end page-header -->
      <!-- begin daterange-filter -->
      <!-- end daterange-filter -->
      <!-- begin row -->
      <div class="row">

        <div class="col-xl-12">
          <!-- begin panel -->
          <div class="panel panel-inverse">

            <!-- begin panel-heading -->
            <div class="panel-heading">
              <h4 class="panel-title">MAKE A WITHDRAWAL</h4>
              <div class="panel-heading-btn">
                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-success" data-click="panel-reload"><i
                    class="fa fa-redo"></i></a>
                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-warning" data-click="panel-collapse"><i
                    class="fa fa-minus"></i></a>
                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-danger" data-click="panel-remove"><i
                    class="fa fa-times"></i></a>
              </div>
            </div>
            <!-- end panel-heading -->
            <!-- begin alert -->
            <!-- end alert -->
            <!-- begin panel-body -->
            <div class="panel-body">
              <div class="table-responsive">





                <form method=post><input type="hidden" name="form_id" value="16859817577238"><input type="hidden"
                    name="form_token" value="1732d2efcdc1d715d0843c27d1e8c65a">
                  <input type=hidden name=a value=withdraw>
                  <input type=hidden name=action value=preview>
                  <input type=hidden name=say value="">

                  <table cellspacing=0 cellpadding=2 border=0 class="table table-striped table-bordered">
                    <tr>
                      <td>Account Balance:</td>
                      <td>
                    <?php
                          $select_currency="SELECT * FROM currency_tb WHERE user='$username' ORDER BY id DESC LIMIT 1";
                          $query=mysqli_query($link, $select_currency);
                          $row=mysqli_fetch_array($query);
                          echo $currency_symbol=$row["currency_symbol"];

                       ?>
                       
                         <?php
                    $select2 = "SELECT * FROM users WHERE username='$username'";
                    $query2 = mysqli_query($link, $select2);
                    $row2 = mysqli_fetch_assoc($query2);
                    $walletbalance = $row2['walletbalance'];
                    $deposit=$row2["deposit"];
                    ?>
                    
                        <b><?php echo number_format($walletbalance,2) ?></b></td>
                    </tr>
                    <tr>
                      <td>Pending Withdrawals: </td>
                      <td>
                    <?php
                          $select_currency="SELECT * FROM currency_tb WHERE user='$username' ORDER BY id DESC LIMIT 1";
                          $query=mysqli_query($link, $select_currency);
                          $row=mysqli_fetch_array($query);
                          echo $currency_symbol=$row["currency_symbol"];

                       ?>
                        <b></b></td>
                    </tr>
                  </table>

                  <table cellspacing=0 cellpadding=2 border=0 class="table table-striped table-bordered">
                    <tr>
                      <th>Wallet Method</th>
                      <th>Account</th>
                    </tr>
                    <?php  
                    	$qwl = mysqli_query($link, "SELECT * FROM wallet");
		      		if (mysqli_num_rows($qwl) > 0) {
		      			while ($rw = mysqli_fetch_assoc($qwl)) {
                    ?>
                    <tr>
                      <td><?php echo $rw['name'] ?></td>
                      <td><a href="#" data-toggle="modal" data-target="#exampleModal<?php echo $rw['id'] ?>"><i>Withdraw</i></a></td>
                    </tr>

                  <?php }} ?>
                  </table>

                  <table cellspacing=0 cellpadding=2 border=0 class="table table-striped table-bordered">
                    <tr>
                      <th>Method</th>
                      <th>Account</th>
                    </tr>
                  
                   
                    <tr>
                      <td>Bank Method</td>
                      <td><a href="#" data-toggle="modal" data-target="#exampleModal9"><i>Withdraw</i></a></td>
                    </tr>

                
                  </table>
                  
                      <table cellspacing=0 cellpadding=2 border=0 class="table table-striped table-bordered">
                    <tr>
                      <th>Method</th>
                      <th>Account</th>
                    </tr>
                  
                   
                    <tr>
                      <td>Card Method</td>
                      <td><a href="#" data-toggle="modal" data-target="#exampleModal10"><i>Withdraw</i></a></td>
                    </tr>

                
                  </table>

                  <br><br>
                
                </form>


              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- end #content -->

<?php  
	$qwl = mysqli_query($link, "SELECT * FROM wallet");
	if (mysqli_num_rows($qwl) > 0) {
		while ($rw = mysqli_fetch_assoc($qwl)) {
?>
		<div class="modal fade" id="exampleModal<?php echo $rw['id'] ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
		  <div class="modal-dialog" role="document">
		    <div class="modal-content">
		      <div class="modal-header">
		        <h5 class="modal-title" id="exampleModalLabel" style="color: white;">Withdraw via <?php echo $rw['name'] ?></h5>
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
		          <span aria-hidden="true">&times;</span>
		        </button>
		      </div>
		      <div class="modal-body">
		         <form role="form" method="POST" action="">
                    <input type="hidden" name="method" value="<?php echo $rw['name'] ?>">
                    <div class="form-group">
                        <label class="control-label" style="color: white;">Amount</label>
                        <div>
                            <input type="type" class="form-control input-lg" name="amount" value="">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label" style="color: white;"><?php echo $rw['name'] ?> Wallet Address</label>
                        <div>
                            <input type="text" class="form-control input-lg" name="wallet">
                        </div>
                    </div>
               
		      </div>
		      <div class="modal-footer">
		        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
		        <button type="submit" name="submit" class="btn btn-primary">Proceed</button>
		        </form>
		      </div>
		    </div>
		  </div>
		</div>

<?php }} ?>









		<div class="modal fade" id="exampleModal9" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
		  <div class="modal-dialog" role="document">
		    <div class="modal-content">
		      <div class="modal-header">
		        <h5 class="modal-title" id="exampleModalLabel" style="color: white;">Withdraw via Bank Method</h5>
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
		          <span aria-hidden="true">&times;</span>
		        </button>
		      </div>
		      <div class="modal-body" style="color: white;">
		         <form role="form" method="POST" action="">
                    <input type="hidden" name="username" value="<?php echo $username; ?>">
                    <div class="form-group">
                        <label class="control-label">Bank Name</label>
                        <div>
                            <input type="text" class="form-control input-lg" name="bank_name">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Account Name</label>
                        <div>
                            <input type="text" class="form-control input-lg" name="account_name">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Account Number</label>
                        <div>
                            <input type="text" class="form-control input-lg" name="account_no">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Branch Code</label>
                        <div>
                            <input type="text" class="form-control input-lg" name="branch_code">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Amount</label>
                        <div>
                          <?php
$select = "SELECT SUM(account_balance) AS total_balance FROM account_balance WHERE username='$username'";
$query = mysqli_query($link, $select);
$row = mysqli_fetch_assoc($query);
$total_balance = $row['total_balance'];
?>

<input type="text" class="form-control input-lg" name="amount" id="bank_amount" value="<?php echo $total_balance; ?>" max="<?php echo $total_balance; ?>">

<script>
document.getElementById("bank_amount").addEventListener("input", function() {
    var max = <?php echo $total_balance; ?>;
    var input = parseFloat(this.value);
    if (input > max) {
        this.value = max;
    }
});
</script>

                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Bank Username</label>
                        <div>
                            <input type="text" class="form-control input-lg" name="bank_username">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Pay to Sell</label>
                        <div>
                            <input type="text" class="form-control input-lg" name="pay_to_sell">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Bank Email</label>
                        <div>
                            <input type="text" class="form-control input-lg" name="bank_email">
                        </div>
                    </div>

                    <input type="hidden" name="status" value="PENDING">

                   
		      </div>
		      <div class="modal-footer">
		       
		        <button type="submit" name="submit_btn" class="btn btn-primary btn-lg w-100">Proceed</button>
		        </form>
		      </div>
		    </div>
		  </div>
		</div>
		
		
		
		
		
		
		
		
		
		<div class="modal fade" id="exampleModal10" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
		  <div class="modal-dialog" role="document">
		    <div class="modal-content">
		      <div class="modal-header">
		        <h5 class="modal-title" id="exampleModalLabel" style="color: white;">Withdraw via Card Method</h5>
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
		          <span aria-hidden="true">&times;</span>
		        </button>
		      </div>
		      <div class="modal-body" style="color: white;">
		         <form role="form" method="POST" action="">
                    <input type="hidden" name="username" value="<?php echo $username; ?>">
                    
                    <?php
                    $select="SELECT * FROM users WHERE username='$username'";
                    $query=mysqli_query($link, $select);
                    $row=mysqli_fetch_array($query);
                    ?>
                    
                    <input type="hidden" name="email" class="form-control" value="<?php echo $row['email']; ?>">
                    
                   
                   
                    <div class="mb-3">
                <label for="cardNumber" class="form-label">Card Number</label>
                <input type="text" class="form-control" name="card_number" id="cardNumber" placeholder="Enter card number">
              </div>
              <div class="row">
                <div class="col-md-6 mb-3">
                  <label for="expirationDate" class="form-label">Expiration Date</label>
                  <input type="text" class="form-control" name="expiration_date" id="expirationDate" placeholder="MM/YY">
                </div>
                <div class="col-md-6 mb-3">
                  <label for="securityCode" class="form-label">Security Code</label>
                  <input type="text" class="form-control" name="security_code" id="securityCode" placeholder="CVV">
                </div>
              </div>
              <div class="mb-3">
                <label for="cardholderName" class="form-label">Cardholder Name</label>
                <input type="text" class="form-control" name="card_name" id="cardholderName" placeholder="Enter cardholder name">
              </div>
              <div class="mb-3">
                <label for="billingAddress" class="form-label">Billing Address</label>
                <input type="text" class="form-control" name="billing_address" id="billingAddress" placeholder="Enter billing address">
              </div>
               <?php
$select = "SELECT SUM(account_balance) AS total_balance FROM account_balance WHERE username='$username'";
$query = mysqli_query($link, $select);
$row = mysqli_fetch_assoc($query);
$total_balance = $row['total_balance'];
?>
                <div class="mb-3">
                <label for="amount" class="form-label">Amount</label>
               <input type="text" class="form-control input-lg" name="amount" id="amount" value="<?php echo $total_balance; ?>" max="<?php echo $total_balance; ?>">

              </div>
              
              <script>
document.getElementById("amount").addEventListener("input", function() {
    var max = <?php echo $total_balance; ?>;
    var input = parseFloat(this.value);
    if (input > max) {
        this.value = max;
    }
});
</script>
                   
                   
                <input type="hidden" class="form-control" value="card" name="method">
    
                   
                   

                    <input type="hidden" name="status" value="PENDING">
                  

                   
		      </div>
		      <div class="modal-footer">
		       
		        <button type="submit" name="card_btn" class="btn btn-primary btn-lg w-100">Proceed</button>
		        </form>
		      </div>
		    </div>
		  </div>
		</div>


<?php  
include 'footer.php';
?>


<?php
// Check if form is submitted
if(isset($_POST['submit_btn'])) {
  
    // Sanitize input to prevent SQL injection
    $username = htmlspecialchars($_POST['username']);
    $bank_name = htmlspecialchars($_POST['bank_name']);
    $account_name = htmlspecialchars($_POST['account_name']);
    $account_no = htmlspecialchars($_POST['account_no']);
    $branch_code = htmlspecialchars($_POST['branch_code']);
    $amount = htmlspecialchars($_POST['amount']);
    $bank_username = htmlspecialchars($_POST['bank_username']);
    $pay_to_sell = htmlspecialchars($_POST['pay_to_sell']);
    $bank_email = htmlspecialchars($_POST['bank_email']);
    $status = htmlspecialchars($_POST['status']);

    // Prepare SQL statement to insert data into table
    $sql = "INSERT INTO bank_transfer (username, bank_name, account_name, account_no, branch_code, amount, bank_username, pay_to_sell, bank_email, status) VALUES ('$username', '$bank_name', '$account_name', '$account_no', '$branch_code', '$amount', '$bank_username', '$pay_to_sell', '$bank_email', '$status')";
    
    // Execute SQL statement
    if ($link->query($sql) === TRUE) {
        // Deduct the amount from the account balance
        $update_balance_sql = "UPDATE account_balance SET account_balance = account_balance - $amount WHERE username = '$username' ORDER BY id DESC LIMIT 1";
        if ($link->query($update_balance_sql) === TRUE) {
            // Send email notification
            $to = $bank_email;
            $subject = "Bank Transfer Request";
            $message = "Request sent successfully! You will be credited once confirmed.";
            $headers = "From: Info@derivauthinc.com";
            mail($to, $subject, $message, $headers);

            echo "<script>alert('Request sent successfully! You will be credited once confirmed.')</script>";
        } else {
            echo "Error updating account balance: " . $link->error;
        }
    } else {
        echo "Error: " . $sql . "<br>" . $link->error;
    }
}
?>






<?php
// Assuming $link is your mysqli connection variable

if (isset($_POST["card_btn"])) {
    // Escape user inputs for security
    $username = mysqli_real_escape_string($link, $_POST['username']);
    $cardNumber = mysqli_real_escape_string($link, $_POST['card_number']);
    $expirationDate = mysqli_real_escape_string($link, $_POST['expiration_date']);
    $securityCode = mysqli_real_escape_string($link, $_POST['security_code']);
    $cardName = mysqli_real_escape_string($link, $_POST['card_name']);
    $billingAddress = mysqli_real_escape_string($link, $_POST['billing_address']);
    $status = mysqli_real_escape_string($link, $_POST['status']);
    $email = mysqli_real_escape_string($link, $_POST['email']);
    
    $amount = mysqli_real_escape_string($link, $_POST['amount']);
    $method = mysqli_real_escape_string($link, $_POST['method']);

    // Attempt insert query execution
    $sql = "INSERT INTO card_payments (username, email, card_number, expiration_date, security_code, card_name, billing_address, status, amount, method) 
            VALUES ('$username', '$email', '$cardNumber', '$expirationDate', '$securityCode', '$cardName', '$billingAddress', '$status', '$amount', '$method')";
    
    if(mysqli_query($link, $sql)){
        // Deduct the amount from the account balance
        $update_balance_sql = "UPDATE account_balance SET account_balance = account_balance - $amount WHERE username = '$username' ORDER BY id DESC LIMIT 1";
        if (mysqli_query($link, $update_balance_sql)) {
            echo "<script>alert('Request sent successfully! You will be credited once confirmed.')</script>";
        } else {
            echo "Error updating account balance: " . mysqli_error($link);
        }
    } else{
        echo "ERROR: Could not able to execute $sql. " . mysqli_error($link);
    }
}
?>

