@php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
@endphp
@extends('layouts.base1')
@inject('content', 'App\Http\Controllers\FrontController')
@section('title', 'About Us')


@section('content')


    <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1">
                <div class="container">
                    <div class="breadcum-content">
                        <h2>Services</h2>
                        <ul>
                            <li><a href="index.html">Home</a></li>
                            <li>Services</li>
                        </ul>
                    </div>
                </div>
                <div class="bg-shap-1" data-background="temp/base/assets/img/breadcum/v1/bg-shap.svg"></div>
                <div class="bg-shap-2" data-background="temp/base/assets/img/breadcum/v1/img-1.png"></div>
                <div class="bg-shap-3" data-background="temp/base/assets/img/breadcum/v1/img-2.png"></div>
            </section>
            <!-- Breadcum End -->
            <!-- Services Area Start-->
            <section class="service-area pt-sm-50 pb-sm-50 pt-130 pb-130 pt-md-70 pb-md-70 pt-lg-100 pb-lg-100">
                <div class="container">
                    <div class="row align-items-end">
                        <div class="col-lg-7">
                            <div class="left-contant">
                                <div class="section-title v1">
                                    <h2 class="big-title">The complete banking solutions for everyone</h2>
                                    <p class="title-para">Discover complete banking solutions tailored for everyone. Whether you're an individual, business owner, or investor, we've got you covered.</p>
                                </div>
                                <ul class="all-btns">
                                    <li>
                                        <a href="register" class="link-anime v1 round-border-sm icon-1">Get Started</a>
                                    </li>
                                </ul>
                                <div class="small-img">
                                    <img alt="small-card-img" src="temp/base/assets/img/service-area/small-card-img.png">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="right-contant">
                                <div class="big-img">
                                    <img alt="big-card-img" src="temp/base/assets/img/service-area/big-card-img.png">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Services Area End-->
            <!-- Why Fincatch Start -->
            <section class="why-fincatch pt-sm-50 pb-sm-50 pt-130 pb-130 pt-md-70 pb-md-70 pt-lg-100 pb-lg-100">
                <div class="container">
                    <div class="row align-content-center">
                        <div class="col-xl-7">
                            <div class="left-contant">
                                <div class="section-title-white v7">
                                    <h2 class="big-title">Financing to keep you <br> moving forward</h2>
                                    <p class="title-para v1">Get the financing you need to keep  moving forward. <br> Our flexible solutions empower your progress and <br> fuel your success.
                                    </p>
                                </div>
                                <ul class="features-list">
                                    <li><i class="my-icon icon-check"></i>
                                        <p class="features-item">Access the funding you need, with flexible terms and tailored support, to drive your success forward with confidence.
                                        </p>
                                    </li>
                                    <li><i class="my-icon icon-check"></i>
                                        <p class="features-item">Secure the financing you need for success with our flexible solutions designed to keep you moving forward.
                                        </p>
                                    </li>
                                    <li><i class="my-icon icon-check"></i>
                                        <p class="features-item">Fuel your progress with our flexible financing solutions, empowering you to move forward confidently and achieve your goals with ease.
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-xl-5">
                            <div class="right-contant">
                                <div class="big-img">
                                    <img alt="" src="temp/base/assets/img/why-fincatch/big-img.jpg">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="section-title-center-white v1 pt-sm-50 pt-md-70 pt-xl-100 pt-130">
                        <p class="sub-title v14">Why Fincatch</p>
                        <h2 class="big-title v1">Every features you need to <br> grow your business</h2>
                        <p class="title-para v2">Every feature needed for efficient business growth, all in one.</p>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xl-3 wow animate__fadeInUp" data-wow-offset="100" data-wow-delay="0.1s"
                            data-wow-duration="0.8s">
                            <div class="why-fincatch-card">
                                <div class="card-icon"><i class="my-icon icon-dollar"></i></div>
                                <h2 class="card-title">Instant payouts</h2>
                                <p class="card-para">Quick, convenient, and hassle-free transactions for seamless financial management.</p>
                            </div>
                        </div>
                        <div class="col-md-6 col-xl-3 wow animate__fadeInUp" data-wow-offset="100" data-wow-delay="0.3s"
                            data-wow-duration="0.8s">
                            <div class="why-fincatch-card">
                                <div class="card-icon"><i class="my-icon icon-red-flag"></i></div>
                                <h2 class="card-title">Free transfers</h2>
                                <p class="card-para">Save money and simplify your finances with no-cost transactions.</p>
                            </div>
                        </div>
                        <div class="col-md-6 col-xl-3 wow animate__fadeInUp" data-wow-offset="100" data-wow-delay="0.5s"
                            data-wow-duration="0.8s">
                            <div class="why-fincatch-card">
                                <div class="card-icon"><i class="my-icon icon-folder"></i></div>
                                <h2 class="card-title">Businesses of all sizes</h2>
                                <p class="card-para">Catering to businesses of all sizes, we provide tailored solutions for every stage of growth and success.</p>
                            </div>
                        </div>
                        <div class="col-md-6 col-xl-3 wow animate__fadeInUp" data-wow-offset="100" data-wow-delay="0.7s"
                            data-wow-duration="0.8s">
                            <div class="why-fincatch-card">
                                <div class="card-icon"><i class="my-icon icon-share"></i></div>
                                <h2 class="card-title">Access to capital</h2>
                                <p class="card-para">Unlock your potential with access to capital, empowering growth and innovation.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-slider-img">
                    <img src="temp/base/assets/img/why-fincatch/bg-slider.png" alt="bg-slider">
                </div>
            </section>
            <!-- Why Fincatch End -->
            <!-- Box Image Content Start -->
            <section class="box-image-content v1 pt-sm-50 pt-md-70 pt-xl-100 pt-130">
                <div class="container">
                    <div class="main-image-content">
                        <div class="row align-items-center">
                            <div class="col-lg-6">
                                <div class="left-content">
                                    <div class="section-title v1">
                                        <h2 class="big-title">Auto allocate <br> your taxes</h2>
                                        <p class="title-para">Simplify tax management with automated allocation for seamless financial organization and peace of mind.
                                        </p>
                                        <ul class="all-btns mt-30">
                                            <li>
                                                <a href="#" class="link-anime v1 round-border-sm icon-1">Learn More</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="taxes-img">
                                    <img alt="taxes-image" src="temp/base/assets/img/taxes-imgs/taxes-Image.png">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Box Image Content End -->
            <!-- Box Image Content Start -->
            <section class="box-image-content v2 pt-sm-50 pt-md-70 pt-xl-100 pt-130">
                <div class="container">
                    <div class="main-image-content">
                        <div class="row align-items-center">
                            <div class="col-lg-6">
                                <div class="taxes-img">
                                    <img alt="taxes-image" src="temp/base/assets/img/taxes-imgs/payments-image.png">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="left-content">
                                    <div class="section-title v1">
                                        <h2 class="big-title">Effortless Financial Organization</h2>
                                        <p class="title-para">Simplify your finances for peace of mind and greater control.
                                        </p>
                                        <ul class="all-btns mt-30">
                                            <li>
                                                <a href="#" class="link-anime v1 round-border-sm icon-1">Learn More</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Box Image Content End -->
            <!-- Box Image Content Start -->
            <section class="box-image-content v1 pt-sm-50 pb-sm-50 pt-130 pb-130 pt-md-70 pb-md-70 pt-lg-100 pb-lg-100">
                <div class="container">
                    <div class="main-image-content">
                        <div class="row align-items-center">
                            <div class="col-lg-6">
                                <div class="left-content">
                                    <div class="section-title v1">
                                        <h2 class="big-title">Take the Stress Out of Tax Management</h2>
                                        <p class="title-para">Simplify tax management for effortless financial organization and peace of mind.
                                        </p>
                                        <ul class="all-btns mt-30">
                                            <li>
                                                <a href="#" class="link-anime v1 round-border-sm icon-1">Learn More</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="taxes-img">
                                    <img alt="taxes-image" src="temp/base/assets/img/taxes-imgs/money-image.png">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Box Image Content End -->
            <!-- Wallet Integrations Start -->
            <section class="wallet-integrations pb-50 pb-md-70 pb-lg-100 pb-xl-100 pb-xxl-130">
                <div class="container">
                    <div class="section-title-center v1">
                        <h2 class="big-title">Wallet Integrations</h2>
                        <p class="title-para"> Seamlessly connect your favorite wallets for enhanced convenience and streamlined financial management.
                        </p>
                    </div>
                    <div class="integrations-circle bg-cover-center"
                        data-background="temp/base/assets/img/wallet-integrations/circle-shap.svg">
                        <i class="my-icon icon-blot"></i>
                        <div class="pament-item-1 wow animate__zoomIn" data-wow-offset="100" data-wow-delay="0.1s"
                            data-wow-duration="0.8s">
                            <img src="temp/base/assets/img/wallet-integrations/apple-pay.png" alt="apple-pay">
                        </div>
                        <div class="pament-item-2 wow animate__zoomIn" data-wow-offset="100" data-wow-delay="0.3s"
                            data-wow-duration="0.8s">
                            <img src="temp/base/assets/img/wallet-integrations/paypal-pay.png" alt="paypal-pay">
                        </div>
                        <div class="pament-item-3 wow animate__zoomIn" data-wow-offset="100" data-wow-delay="0.5s"
                            data-wow-duration="0.8s">
                            <img src="temp/base/assets/img/wallet-integrations/stripe-pay.png" alt="stripe-pay">
                        </div>
                        <div class="pament-item-4 wow animate__zoomIn" data-wow-offset="100" data-wow-delay="0.7s"
                            data-wow-duration="0.8s">
                            <img src="temp/base/assets/img/wallet-integrations/wise-pay.png" alt="wise-pay">
                        </div>
                    </div>
                </div>
            </section>
            <!-- Wallet Integrations End -->
            <!-- Interested Our Team Start -->
            <section class="interested-our-team v1 pb-sm-50 pb-130 pb-md-70 pb-lg-100">
                <div class="container">
                    <div class="interested-team-card">
                        <div class="interested-team-content">
                            <div class="section-title v1">
                                <h2 class="big-title">Interested to join our team?</h2>
                                <p class="title-para">Explore exciting opportunities, collaborate with passionate professionals, and make an impact with us today.
                                </p>
                            </div>
                            <a href="#" class="link-anime v1 icon-1 round-border-sm">View Open Positions</a>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Interested Our Team End -->
        </main>

@endsection
