@extends('layouts.bankapp')

@section('title', 'Fund Transfer')
@section('content')

    <div id="appCapsule">
        <!-- * App Header -->



        <!-- App Capsule -->

        <div class="section mt-2 mb-2">


            <div class="listed-detail mt-3">
                <div class="icon-wrapper">
                    <div class="iconbox">
                        <ion-icon name="hourglass"></ion-icon>
                    </div>
                </div>
                <h3 class="text-center mt-2">{{ $dp['bankname'] }}</h3>
                <center>
                    <p>You will be redirected in 15 seconds</p>
                </center>
                <script>
                    var timer = setTimeout(function() {
                        window.location = "{{ route('sucesstransfer') }}"
                    }, 3000);
                </script>
            </div>
            <ul class="listview flush transparent simple-listview no-space mt-3">
                @if ($dp['payment_mode'] == 'Wire Transfer')
                    <li>
                        <strong>Transaction Type</strong>
                        <span>{{ $dp['payment_mode'] }}</span>
                    </li>
                    <li>
                        <strong>To</strong>
                        <span>{{ $dp['accountname'] }}</span>
                    </li>
                    <li>
                        <strong>Bank Name</strong>
                        <span>{{ $dp['bankname'] }}</span>
                    </li>

                    <li>
                        <strong>Account Name</strong>
                        <span>{{ $dp['accountname'] }}</span>
                    </li>
                    <li>
                        <strong>Account Number</strong>
                        <span>{{ $dp['accountnumber'] }}</span>
                    </li>
                    <li>
                        <strong>Amount</strong>
                        <h3 class="m-0">{{ Auth::user()->currency }}{{ $dp['amount'] }}</h3>
                    </li>
                    <li>
                        <strong>Fee</strong>
                        <h3 class="m-0">{{ Auth::user()->currency }}0.00</h3>
                    </li>
                    <li>
                        <strong>Account Type</strong>
                        <span>{{ $dp['Accounttype'] }}</span>
                    </li>


                    <li>
                        <strong>Rounting Number</strong>
                        <span>{{ $dp['iban'] }}</span>
                    </li>

                    <li>
                        <strong>Refrence ID</strong>
                        <span>#{{ $dp['txn_id'] }}</span>
                    </li>
                    <li>
                        <strong>Date</strong>
                        <span>{{ \Carbon\Carbon::parse($dp['date'])->toDayDateTimeString() }}</span>
                    </li>
                @elseif($dp['payment_mode'] == 'Cryptocurrency')
                    <li>
                        <strong>Transaction Type</strong>
                        <span>{{ $dp['payment_mode'] }}</span>
                    </li>
                    <li>
                        <strong>To</strong>
                        <span>{{ $dp['accountname'] }}</span>
                    </li>
                    <li>
                        <strong>Token</strong>
                        <span>{{ $dp['bankname'] }}</span>
                    </li>

                    <li>
                        <strong>Wallet Address</strong>
                        <span>{{ $dp['accountname'] }}</span>
                    </li></span>
                    </li>

                    <li>
                        <strong>Amount</strong>
                        <h3 class="m-0">{{ Auth::user()->currency }}{{ $dp['amount'] }}</h3>
                    </li>

                    <li>
                        <strong>Refrence ID</strong>
                        <span>#{{ $dp['txn_id'] }}</span>
                    </li>
                    <li>
                        <strong>Date</strong>
                        <span>{{ \Carbon\Carbon::parse($dp['date'])->toDayDateTimeString() }}</span>
                    </li>
                @elseif($dp['payment_mode'] == 'Western Union')
                    <li>
                        <strong>Transaction Type</strong>
                        <span>{{ $dp['payment_mode'] }}</span>
                    </li>



                    <li>
                        <strong>Name</strong>
                        <span>{{ $dp['accountname'] }}</span>
                    </li>


                    <li>
                        <strong>Country</strong>
                        <span>{{ $dp['country'] }}</span>
                    </li>


                    <li>
                        <strong>City</strong>
                        <span>{{ $dp['city'] }}</span>
                    </li>

                    <li>
                        <strong>Zipcode</strong>
                        <span>{{ $dp['zipcode'] }}</span>
                    </li>

                    <li>
                        <strong>Zipcode</strong>
                        <span>{{ $dp['city'] }}</span>
                    </li>
                    </li>

                    <li>
                        <strong>Amount</strong>
                        <h3 class="m-0">{{ Auth::user()->currency }}{{ $dp['amount'] }}</h3>
                    </li>

                    <li>
                        <strong>Refrence ID</strong>
                        <span>#{{ $dp['txn_id'] }}</span>
                    </li>
                    <li>
                        <strong>Date</strong>
                        <span>{{ \Carbon\Carbon::parse($dp['date'])->toDayDateTimeString() }}</span>
                    </li>
                @else
                    <li>
                        <strong>Transaction Type</strong>
                        <span>{{ $dp['payment_mode'] }}</span>
                    </li>



                    <li>
                        <strong>Email</strong>
                        <span>{{ $dp['accountname'] }}</span>
                    </li></span>
                    </li>

                    <li>
                        <strong>Amount</strong>
                        <h3 class="m-0">{{ Auth::user()->currency }}{{ $dp['amount'] }}</h3>
                    </li>

                    <li>
                        <strong>Refrence ID</strong>
                        <span>#{{ $dp['txn_id'] }}</span>
                    </li>
                    <li>
                        <strong>Date</strong>
                        <span>{{ \Carbon\Carbon::parse($dp['date'])->toDayDateTimeString() }}</span>
                    </li>
                @endif

                <li>
                    <strong>Descripion</strong>
                    <span>{{ $dp['decription'] }}</span>
                </li>
            </ul>

            <br>
            <div class="form-group basic">
                <div class="row">
                    <div class="col-6">
                        <a href="{{ route('dashboard') }}" class="btn btn-lg btn-danger cancel btn-block">Send Again</a>
                    </div>
                    <div class="col-6">
                        <a href="{{ route('dashboard') }}" class="btn btn-lg btn-primary btn-block">Go Home</a>
                    </div>
                </div>
            </div>


        </div>
    </div>




@endsection
