@extends('layouts.bankapp')
@section('title', $title)
@section('content')
    <div class="section mt-4">
        <div class="section-heading">
            <h2 class="title">Transactions</h2>
            <a href="{{ route('accounthistory') }}" class="link">View All</a>
        </div>
    </div>

    @foreach ($withdrawals as $withdrawal)
        <div class="section mt-4">
            <div class="transactions">
                <!-- item -->
                <a href="{{ route('transactiondetails', $withdrawal->id) }}" class='item'>
                    <div class="detail">
                        <!-- <img src="assets/img/sample/brand/1.jpg" alt="img" class="image-block imaged w48"> -->
                        <div>
                            @if ($withdrawal->type == 'Credit')
                                <strong>Credit</strong>
                            @else
                                <strong>Debit</strong>
                            @endif
                            @if ($withdrawal->status == 'Pending')
                                <p><span class="badge badge-pill badge-warning badge-sm">{{ $withdrawal->status }}</span>
                                </p>
                            @elseif($withdrawal->status == 'On-hold')
                                <p><span class="badge badge-pill badge-warning badge-sm">{{ $withdrawal->status }}</span>
                                </p>
                            @elseif($withdrawal->status == 'Rejected')
                                <p><span class="badge badge-pill badge-danger badge-sm">{{ $withdrawal->status }}</span>
                                </p>
                            @elseif($withdrawal->status == 'Processed')
                                <p><span class="badge badge-pill badge-success badge-sm">{{ $withdrawal->status }}</span>
                                </p>
                            @else
                                <p><span class="badge badge-pill badge-danger badge-sm">{{ $withdrawal->status }}</span>
                                </p>
                            @endif
                        </div>
                    </div>
                    <div class="right">
                        @if ($withdrawal->type == 'Credit')
                            <div class="price"> <span
                                    style="color:green">{{ Auth::user()->currency }}{{ number_format($withdrawal->amount, 2, '.', ',') }}</span>
                            </div>
                        @else
                            <div class="price"> <span
                                    style="color: #880808">{{ Auth::user()->currency }}{{ number_format($withdrawal->amount, 2, '.', ',') }}</span>
                            </div>
                        @endif
                    </div>
                </a>
                <!-- * item -->
            </div>
        </div>
    @endforeach
    @foreach ($deposits as $withdrawal)
        <div class="section mt-4">

            <div class="transactions">
                <!-- item -->
                <a href="{{ route('depositdetails', $withdrawal->id) }}" class='item'>
                    <div class="detail">
                        <!-- <img src="assets/img/sample/brand/1.jpg" alt="img" class="image-block imaged w48"> -->
                        <div>
                            <strong>Deposit</strong>
                            @if ($withdrawal->status == 'Pending')
                                <p><span class="badge badge-pill badge-warning badge-sm">{{ $withdrawal->status }}</span>
                                </p>
                            @else
                                <p><span class="badge badge-pill badge-success badge-sm">{{ $withdrawal->status }}</span>
                                </p>
                            @endif
                        </div>
                    </div>
                    <div class="right">
                        <div class="price"> <span
                                style="color:green">{{ Auth::user()->currency }}{{ number_format($withdrawal->amount, 2, '.', ',') }}</span>
                        </div>
                    </div>
                </a>
                <!-- * item -->



            </div>
        </div>
    @endforeach

@endsection
