
<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
    <div class="section mt-4">
        <div class="section-heading">
            <h2 class="title">Transactions</h2>
            <a href="<?php echo e(route('accounthistory')); ?>" class="link">View All</a>
        </div>
    </div>

    <?php $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="section mt-4">
            <div class="transactions">
                <!-- item -->
                <a href="<?php echo e(route('transactiondetails', $withdrawal->id)); ?>" class='item'>
                    <div class="detail">
                        <!-- <img src="assets/img/sample/brand/1.jpg" alt="img" class="image-block imaged w48"> -->
                        <div>
                            <?php if($withdrawal->type == 'Credit'): ?>
                                <strong>Credit</strong>
                            <?php else: ?>
                                <strong>Debit</strong>
                            <?php endif; ?>
                            <?php if($withdrawal->status == 'Pending'): ?>
                                <p><span class="badge badge-pill badge-warning badge-sm"><?php echo e($withdrawal->status); ?></span>
                                </p>
                            <?php elseif($withdrawal->status == 'On-hold'): ?>
                                <p><span class="badge badge-pill badge-warning badge-sm"><?php echo e($withdrawal->status); ?></span>
                                </p>
                            <?php elseif($withdrawal->status == 'Rejected'): ?>
                                <p><span class="badge badge-pill badge-danger badge-sm"><?php echo e($withdrawal->status); ?></span>
                                </p>
                            <?php elseif($withdrawal->status == 'Processed'): ?>
                                <p><span class="badge badge-pill badge-success badge-sm"><?php echo e($withdrawal->status); ?></span>
                                </p>
                            <?php else: ?>
                                <p><span class="badge badge-pill badge-danger badge-sm"><?php echo e($withdrawal->status); ?></span>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="right">
                        <?php if($withdrawal->type == 'Credit'): ?>
                            <div class="price"> <span
                                    style="color:green"><?php echo e(Auth::user()->currency); ?><?php echo e(number_format($withdrawal->amount, 2, '.', ',')); ?></span>
                            </div>
                        <?php else: ?>
                            <div class="price"> <span
                                    style="color: #880808"><?php echo e(Auth::user()->currency); ?><?php echo e(number_format($withdrawal->amount, 2, '.', ',')); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                </a>
                <!-- * item -->
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="section mt-4">

            <div class="transactions">
                <!-- item -->
                <a href="<?php echo e(route('depositdetails', $withdrawal->id)); ?>" class='item'>
                    <div class="detail">
                        <!-- <img src="assets/img/sample/brand/1.jpg" alt="img" class="image-block imaged w48"> -->
                        <div>
                            <strong>Deposit</strong>
                            <?php if($withdrawal->status == 'Pending'): ?>
                                <p><span class="badge badge-pill badge-warning badge-sm"><?php echo e($withdrawal->status); ?></span>
                                </p>
                            <?php else: ?>
                                <p><span class="badge badge-pill badge-success badge-sm"><?php echo e($withdrawal->status); ?></span>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="right">
                        <div class="price"> <span
                                style="color:green"><?php echo e(Auth::user()->currency); ?><?php echo e(number_format($withdrawal->amount, 2, '.', ',')); ?></span>
                        </div>
                    </div>
                </a>
                <!-- * item -->



            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.bankapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/remedycodes/public_html/banky2.remedycodes.store/resources/views/user/transactions.blade.php ENDPATH**/ ?>