
<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
    <div class="appHeader">
        <div class="left">
            <a href="<?php echo e(route('dashboard')); ?>" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Transaction Detail
        </div>

    </div>

    <!-- App Capsule -->
    <div id="appCapsule" class="full-height">

        <div class="section mt-2 mb-2">


            <div class="listed-detail mt-3">
                <div class="icon-wrapper">
                    <div class="iconbox">
                        <ion-icon name="arrow-forward-outline"></ion-icon>
                    </div>
                </div>
                <h3 class="text-center mt-2">Payment</h3>
            </div>

            <ul class="listview flush transparent simple-listview no-space mt-3">
                <li>
                    <strong>Date</strong>
                    <?php echo e(\Carbon\Carbon::parse($transaction->created_at)->toDayDateTimeString()); ?>

                </li>

                <li>
                    <strong>Method</strong>
                    <?php echo e($transaction->payment_mode); ?>

                </li>
                <li>
                    <strong>Status</strong>
                    <?php if($transaction->status == 'Pending'): ?>
                        <span class="badge badge-pill badge-warning badge-sm"><?php echo e($transaction->status); ?></span>
                    <?php else: ?>
                        <span class="badge badge-pill badge-success badge-sm"><?php echo e($transaction->status); ?></span>
                    <?php endif; ?>
                </li>
                <li>
                    <strong>Transaction ID</strong>
                    <span><?php echo e($transaction->txn_id); ?></span>
                </li>


                <li>
                    <strong>Amount</strong>
                    <h3 class="m-0">
                        <?php if($transaction->type == 'Credit'): ?>
                            <span class="text-success">

                                <?php echo e(Auth::user()->currency); ?><?php echo e(number_format($transaction->amount, 2, '.', ',')); ?>

                            </span>
                        <?php else: ?>
                            <span class="text-danger">

                                <?php echo e(Auth::user()->currency); ?><?php echo e(number_format($transaction->amount, 2, '.', ',')); ?>

                            </span>
                        <?php endif; ?>
                    </h3>
                </li>

            </ul>


        </div>

    </div>
    <!-- * App Capsule -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.bankapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/remedycodes/public_html/banky2.remedycodes.store/resources/views/user/depositdetails.blade.php ENDPATH**/ ?>