<?php
session_start();
include("../connection.php"); // make sure path is correct

// Check if admin is logged in
if (!isset($_SESSION['admin'])) {
    header("Location: ../admin-login.php");
    exit();
}

$success = "";

// ================= SETTINGS ================= //
$sql = "SELECT * FROM settings LIMIT 1";
$result = mysqli_query($conn, $sql);
$settings = mysqli_fetch_assoc($result);

if (isset($_POST['save_settings'])) {
    $address1   = mysqli_real_escape_string($conn, $_POST['address1']);
    $address2   = mysqli_real_escape_string($conn, $_POST['address2']);
    $phone1     = mysqli_real_escape_string($conn, $_POST['phone1']);
    $phone2     = mysqli_real_escape_string($conn, $_POST['phone2']);
    $email1     = mysqli_real_escape_string($conn, $_POST['email1']);
    $email2     = mysqli_real_escape_string($conn, $_POST['email2']);
    $email3     = mysqli_real_escape_string($conn, $_POST['email3']);

    if ($settings) {
        $update = "UPDATE settings SET 
            address1='$address1',
            address2='$address2',
            phone1='$phone1',
            phone2='$phone2',
            email1='$email1',
            email2='$email2',
            email3='$email3'
            WHERE id=" . $settings['id'];
        mysqli_query($conn, $update);
    } else {
        $insert = "INSERT INTO settings (address1, address2, phone1, phone2, email1, email2, email3) 
                   VALUES ('$address1', '$address2', '$phone1', '$phone2', '$email1', '$email2', '$email3')";
        mysqli_query($conn, $insert);
    }

    $success = "Settings saved successfully!";
    $result = mysqli_query($conn, "SELECT * FROM settings LIMIT 1");
    $settings = mysqli_fetch_assoc($result);
}

// ================= SPECIALIST ================= //
$sql_specialist = "SELECT * FROM specialists LIMIT 1";
$result_specialist = mysqli_query($conn, $sql_specialist);
$specialist = mysqli_fetch_assoc($result_specialist);

if (isset($_POST['save_specialist'])) {
    $title   = mysqli_real_escape_string($conn, $_POST['title']);
    $details = mysqli_real_escape_string($conn, $_POST['details']);

    if ($specialist) {
        $update = "UPDATE specialists SET 
            title='$title',
            details='$details'
            WHERE id=" . $specialist['id'];
        mysqli_query($conn, $update);
    } else {
        $insert = "INSERT INTO specialists (title, details) VALUES ('$title', '$details')";
        mysqli_query($conn, $insert);
    }

    $success = "Specialist details saved successfully!";
    $result_specialist = mysqli_query($conn, "SELECT * FROM specialists LIMIT 1");
    $specialist = mysqli_fetch_assoc($result_specialist);
}

// ================= DOCTOR PROFILE ================= //
$sql_doctor = "SELECT * FROM doctors LIMIT 1";
$result_doctor = mysqli_query($conn, $sql_doctor);
$doctor = mysqli_fetch_assoc($result_doctor);



// ================= DOCTOR PROFILES ================= //
if (isset($_POST['save_doctor'])) {
    $name       = mysqli_real_escape_string($conn, $_POST['name']);
    $position   = mysqli_real_escape_string($conn, $_POST['position']);
    $experience = mysqli_real_escape_string($conn, $_POST['experience']);
    $university = mysqli_real_escape_string($conn, $_POST['university']);
    $photo      = mysqli_real_escape_string($conn, $_POST['photo']);

    // Always insert a new doctor
    $insert = "INSERT INTO doctors (name, position, experience, university, photo) 
               VALUES ('$name', '$position', '$experience', '$university', '$photo')";
    mysqli_query($conn, $insert);

    $success = "Doctor profile added successfully!";
}

// Fetch all doctors
$doctors = mysqli_query($conn, "SELECT * FROM doctors ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <div class="container-fluid">
      <a class="navbar-brand" href="#">Admin Dashboard</a>
      <div class="d-flex">
        <span class="text-white me-3">Welcome, <?php echo htmlspecialchars($_SESSION['admin']); ?></span>
        <a href="../logout.php" class="btn btn-outline-light">Logout</a>
      </div>
    </div>
  </nav>

  <div class="container mt-5">
    <!-- Settings Form -->
    <div class="card shadow p-4 mb-4">
      <h3>Website Settings</h3>
      <?php if (!empty($success)) { ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
      <?php } ?>

      <form method="POST">
        <div class="row">
          <div class="col-md-6 mb-3">
            <label class="form-label">Address 1</label>
            <input type="text" name="address1" class="form-control" 
              value="<?php echo isset($settings['address1']) ? htmlspecialchars($settings['address1']) : ''; ?>" required>
          </div>
          <div class="col-md-6 mb-3">
            <label class="form-label">Address 2</label>
            <input type="text" name="address2" class="form-control"
              value="<?php echo isset($settings['address2']) ? htmlspecialchars($settings['address2']) : ''; ?>">
          </div>
          <div class="col-md-6 mb-3">
            <label class="form-label">Phone Number 1</label>
            <input type="text" name="phone1" class="form-control"
              value="<?php echo isset($settings['phone1']) ? htmlspecialchars($settings['phone1']) : ''; ?>" required>
          </div>
          <div class="col-md-6 mb-3">
            <label class="form-label">Phone Number 2</label>
            <input type="text" name="phone2" class="form-control"
              value="<?php echo isset($settings['phone2']) ? htmlspecialchars($settings['phone2']) : ''; ?>">
          </div>
          <div class="col-md-4 mb-3">
            <label class="form-label">Email 1</label>
            <input type="email" name="email1" class="form-control"
              value="<?php echo isset($settings['email1']) ? htmlspecialchars($settings['email1']) : ''; ?>" required>
          </div>
          <div class="col-md-4 mb-3">
            <label class="form-label">Email 2</label>
            <input type="email" name="email2" class="form-control"
              value="<?php echo isset($settings['email2']) ? htmlspecialchars($settings['email2']) : ''; ?>">
          </div>
          <div class="col-md-4 mb-3">
            <label class="form-label">Email 3</label>
            <input type="email" name="email3" class="form-control"
              value="<?php echo isset($settings['email3']) ? htmlspecialchars($settings['email3']) : ''; ?>">
          </div>
        </div>
        <button type="submit" name="save_settings" class="btn btn-primary">Save Settings</button>
      </form>
    </div>

    <!-- Specialist Form -->
    <div class="card shadow p-4 mb-4">
      <h3>Specialist Details</h3>
      <form method="POST">
        <div class="mb-3">
          <label class="form-label">Specialist Title</label>
          <input type="text" name="title" class="form-control" placeholder="Orthopedic surgery"
            value="<?php echo isset($specialist['title']) ? htmlspecialchars($specialist['title']) : ''; ?>" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Specialist Details</label>
          <textarea name="details" class="form-control" rows="4" placeholder="Comprehensive surgical and non-surgical care for bones, joints, muscles, and ligaments. Our orthopedic specialists ensure mobility and faster recovery." required><?php echo isset($specialist['details']) ? htmlspecialchars($specialist['details']) : ''; ?></textarea>
        </div>
        <button type="submit" name="save_specialist" class="btn btn-success">Save Specialist</button>
      </form>
    </div>

   <!-- Doctor Profile Form -->
    <div class="card shadow p-4 mb-4">
      <h3>Add Doctor Profile</h3>
      <?php if (!empty($success)) { ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
      <?php } ?>
      <form method="POST">
        <div class="mb-3">
          <label class="form-label">Doctor's Name</label>
          <input type="text" name="name" class="form-control" placeholder="Dr. John Doe" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Position</label>
          <input type="text" name="position" class="form-control" placeholder="Cardiologist" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Experience</label>
          <input type="text" name="experience" class="form-control" placeholder="15 years" required>
        </div>
        <div class="mb-3">
          <label class="form-label">University Graduated From</label>
          <input type="text" name="university" class="form-control" placeholder="Harvard Medical School" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Photo URL</label>
          <input type="url" name="photo" class="form-control" placeholder="https://example.com/photo.jpg" required>
        </div>
        <button type="submit" name="save_doctor" class="btn btn-info">Save Doctor Profile</button>
      </form>
    </div>



  </div>
</body>
</html>
