<?php
include("site-details.php");
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name    = htmlspecialchars(trim($_POST['name']));
    $email   = htmlspecialchars(trim($_POST['email']));
    $phone   = htmlspecialchars(trim($_POST['phone']));
    $message = htmlspecialchars(trim($_POST['message']));

    $to = "contact@ottohansmedicalcenter.com"; // 👉 Change this to your email address
    $subject = "New Contact Form Message from $name";

    $body = "
    You have received a new message from the Medical Excellence contact form.\n\n
    Name: $name\n
    Email: $email\n
    Phone: $phone\n
    Message:\n$message
    ";

    $headers = "From: $email\r\n";
    $headers .= "Reply-To: $email\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();

    if (mail($to, $subject, $body, $headers)) {
        $successMsg = "✅ Thank you, $name! Your message has been sent successfully.";
    } else {
        $errorMsg = "❌ Sorry, your message could not be sent. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Contact Us - Medical Excellence</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<!-- Font Awesome (for icons) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

  <style>
    body {
      font-family: 'Arial', sans-serif;
      background: linear-gradient(160deg, #0d47a1, #1e3c72);
      color: white;
    }
    .nav-link:hover { color: #34c759 !important; }
    .hero-section {
      min-height: 50vh;
      display: flex;
      align-items: center;
      justify-content: center;
      text-align: center;
      padding: 60px 20px;
    }
    .hero-section h1 {
      font-weight: 800;
      font-size: 2.5rem;
      background: linear-gradient(90deg, #34c759, #a0ff99);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }
    .hero-section p { margin-top: 15px; color: #ddd; }
    #contact { padding: 80px 20px; background: #f8f9fa; color: #333; }
    .contact-card {
      border: none;
      border-radius: 16px;
      box-shadow: 0 8px 25px rgba(0,0,0,0.1);
      transition: transform 0.3s;
      background: #fff;
    }
    .contact-card:hover { transform: translateY(-8px); }
    .btn-custom {
      background-color: #34c759;
      border: none;
      padding: 12px 25px;
      border-radius: 50px;
      font-weight: 600;
      color: white;
      transition: 0.3s;
    }
    .btn-custom:hover { background-color: #28a745; transform: translateY(-3px); }
    footer { background: #0d47a1; color: white; padding: 50px 20px; }
    footer a { color: white; text-decoration: none; }
    footer a:hover { color: #34c759; }
  </style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm">
  <div class="container">
    <a class="navbar-brand fw-bold" href="#">
      <img src="logo.png" alt="Logo" style="height:40px;">
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
      <ul class="navbar-nav fw-semibold">
        <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="index.php#services">Services</a></li>
        <li class="nav-item"><a class="nav-link" href="index.php#team">Team</a></li>
        <li class="nav-item"><a class="nav-link" href="index.php#about">About</a></li>
        <li class="nav-item"><a class="nav-link" href="specialties.php">Specialties</a></li>
        <li class="nav-item"><a class="nav-link active" href="contact.php">Contact</a></li>
      </ul>
    </div>
  </div>
</nav>
<!-- Hero -->
<section class="hero-section">
  <div class="container">
    <h1>Get in Touch With Us</h1>
    <p>We’re here to answer your questions and schedule your appointments.</p>
  </div>
</section>

<!-- Contact Section -->
<section id="contact">
  <div class="container">
    <div class="text-center mb-5">
      <h2>Contact Us</h2>
      <p class="text-muted">Send us a message or book an appointment below.</p>
    </div>

    <?php if (!empty($successMsg)): ?>
      <div class="alert alert-success"><?php echo $successMsg; ?></div>
    <?php elseif (!empty($errorMsg)): ?>
      <div class="alert alert-danger"><?php echo $errorMsg; ?></div>
    <?php endif; ?>

    <div class="row">
      <!-- Form -->
      <div class="col-lg-7 mb-4">
        <div class="card contact-card p-4">
          <h5 class="fw-bold mb-3">Send a Message</h5>
          <form method="post" action="">
            <div class="mb-3">
              <label class="form-label">Full Name</label>
              <input type="text" name="name" class="form-control" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="email" class="form-control" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Phone</label>
              <input type="tel" name="phone" class="form-control" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Message</label>
              <textarea name="message" rows="4" class="form-control" required></textarea>
            </div>
            <button type="submit" class="btn btn-custom w-100">Submit</button>
          </form>
        </div>
      </div>

      <!-- Info -->
      <div class="col-lg-5">
        <div class="card contact-card p-4 h-100">
          <h5 class="fw-bold mb-3">Contact Information</h5>
          <ul class="list-unstyled">
            <li class="mb-3"><i class="bi bi-geo-alt-fill me-2 text-primary"></i> <?php echo $row["address1"]; ?></li>

<li class="mb-3">
    <i class="bi bi-geo-alt-fill me-2 text-primary"></i>
   <?php echo $row["address2"]; ?>
</li>
            <li class="mb-3"><i class="bi bi-telephone-fill me-2 text-primary"></i> <?php echo $row["phone1"]; ?></li>
            <li class="mb-3"><i class="bi bi-telephone-fill me-2 text-primary"></i> <?php echo $row["phone2"]; ?></li>
            <li class="mb-3"><i class="bi bi-envelope-fill me-2 text-primary"></i> <?php echo $row["email1"]; ?></li>
            <li class="mb-3"><i class="bi bi-envelope-fill me-2 text-primary"></i> <?php echo $row["email2"]; ?></li>
            <li class="mb-3"><i class="bi bi-envelope-fill me-2 text-primary"></i> <?php echo $row["email3"]; ?></li>
            <li><i class="bi bi-clock-fill me-2 text-primary"></i> Mon - Fri: 9:00 AM - 6:00 PM</li>
          </ul>
          <h6 class="fw-bold mt-4">Follow Us</h6>
          <div class="d-flex gap-3 fs-4">
            <a href="#"><i class="bi bi-facebook"></i></a>
            <a href="#"><i class="bi bi-twitter"></i></a>
            <a href="#"><i class="bi bi-linkedin"></i></a>
            <a href="#"><i class="bi bi-instagram"></i></a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- ================= Footer Section ================= -->
<footer class="bg-dark text-white pt-5 pb-4">
  <div class="container">
    <div class="row align-items-start">

      <!-- About / Logo -->
      <div class="col-md-4 mb-4 d-flex flex-column align-items-start">
        <div class="d-flex align-items-center mb-3">
          <img src="logo.png" alt="Ottohans Medical Center Logo" style="height:50px; margin-right:10px;">
          <h5 class="fw-bold mb-0">Ottohans Medical Center</h5>
        </div>
        <p>We provide top-notch healthcare services with professionalism, innovation, and compassion. Your health is our priority.</p>
      </div>

      <!-- Quick Links -->
      <div class="col-md-2 mb-4">
        <h5 class="fw-bold mb-3">Quick Links</h5>
        <ul class="list-unstyled">
          <li><a href="index.php#home" class="text-white text-decoration-none">Home</a></li>
          <li><a href="index.php#services" class="text-white text-decoration-none">Services</a></li>
          <li><a href="index.php#team" class="text-white text-decoration-none">Team</a></li>
          <li><a href="index.php#about" class="text-white text-decoration-none">About</a></li>
          <li><a href="specialties.php" class="text-white text-decoration-none">Specialties</a></li>
          <li><a href="contact.php" class="text-white text-decoration-none">Contact</a></li>
        </ul>
      </div>

      <!-- Contact Info -->
      <div class="col-md-3 mb-4">
        <h5 class="fw-bold mb-3">Contact Us</h5>
        <p class="mb-2"><i class="bi bi-geo-alt-fill me-2"></i><?php echo $row["address1"]; ?></p>

        <p class="mb-2"><i class="bi bi-geo-alt-fill me-2"></i><?php echo $row["address2"]; ?></p>

        <p class="mb-2"><i class="bi bi-telephone-fill me-2"></i><?php echo $row["phone1"]; ?></p>
        <p class="mb-2"><i class="bi bi-telephone-fill me-2"></i><?php echo $row["phone2"]; ?></p>
        <p class="mb-2"><i class="bi bi-envelope-fill me-2"></i><?php echo $row["email1"]; ?></p>
      </div>

      <!-- Social Media -->
      <div class="col-md-3 mb-4">
        <h5 class="fw-bold mb-3">Follow Us</h5>
        <div class="d-flex gap-3 fs-4">
          <a href="#" class="text-white"><i class="bi bi-facebook"></i></a>
          <a href="#" class="text-white"><i class="bi bi-twitter"></i></a>
          <a href="#" class="text-white"><i class="bi bi-linkedin"></i></a>
          <a href="#" class="text-white"><i class="bi bi-instagram"></i></a>
        </div>
      </div>
    </div>

    <hr class="bg-light">

    <!-- Copyright -->
    <div class="text-center pt-3">
      <p class="mb-0">&copy; 2025 Ottohans Medical Center. All Rights Reserved.</p>
    </div>
  </div>
</footer>

<!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '65d0d39bd9c01850ac614410835da1864214e5ef';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>


<!-- ================= Bootstrap Icons CDN ================= -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">


<!-- ================= Bootstrap Icons CDN ================= -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">


<!-- Font Awesome (for icons) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">


  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>