<?php
include("site-details.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Our Specialties - Medical Excellence</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

  <style>
    body {
      font-family: 'Arial', sans-serif;
      background: linear-gradient(160deg, #0d47a1, #1e3c72);
      color: white;
    }

    /* Navbar */
    .navbar {
      background: #0d47a1;
    }
    .navbar .nav-link {
      color: white !important;
      font-weight: 600;
      margin-left: 15px;
      transition: color 0.3s;
    }
    .navbar .nav-link:hover,
    .navbar .nav-link.active {
      color: #34c759 !important;
    }

    .page-header {
      padding: 100px 20px;
      text-align: center;
      background: rgba(0,0,0,0.5);
    }
    .page-header h1 {
      font-weight: 800;
      font-size: 2.8rem;
      background: linear-gradient(90deg, #34c759, #a0ff99);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }
    .specialties-section {
      padding: 80px 20px;
      background: #f8f9fa;
      color: #333;
    }
    .specialty-card {
      border: none;
      border-radius: 20px;
      padding: 40px 20px;
      text-align: center;
      background: #fff;
      box-shadow: 0 8px 25px rgba(0,0,0,0.1);
      transition: transform 0.3s, box-shadow 0.3s;
    }
    .specialty-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 15px 35px rgba(0,0,0,0.2);
    }
    .specialty-card i {
      font-size: 3rem;
      color: #0d47a1;
      margin-bottom: 20px;
      transition: transform 0.3s, color 0.3s;
    }
    .specialty-card:hover i {
      transform: scale(1.2);
      color: #34c759;
    }
    .specialty-card h5 {
      font-weight: 700;
      margin-bottom: 15px;
    }
    .specialty-card p {
      font-size: 0.95rem;
      color: #666;
    }

    footer {
      background: #0d47a1;
    }
  </style>
</head>
<body>

  <!-- Header / Navbar -->
  <nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container">
      <a class="navbar-brand fw-bold" href="#">
      <img src="logo.png" alt="Logo" style="height:40px;">
    </a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="navbarNav">
        <ul class="navbar-nav ms-auto">
          <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
          <li class="nav-item"><a class="nav-link" href="index.php#about">About</a></li>
          <li class="nav-item"><a class="nav-link active" href="specialties.php">Specialties</a></li>
          <li class="nav-item"><a class="nav-link" href="index.php#services">Services</a></li>
          <li class="nav-item"><a class="nav-link" href="contact.php">Contact</a></li>
        </ul>
      </div>
    </div>
  </nav>

  <!-- Page Header -->
  <div class="page-header">
    <h1>Our Medical Specialties</h1>
    <p class="text-light">Explore our wide range of specialized medical services designed to keep you healthy.</p>
  </div>

  <!-- Specialties Section -->
  <section class="specialties-section">
    <div class="container">
      <div class="row g-4">

        <!-- Orthopedic Surgery -->
        <div class="col-md-4">
          <div class="specialty-card">
            <i class="fas fa-bone"></i>
            <h5><?php echo $row2["title"]; ?></h5>
            <p><?php echo $row2["details"]; ?></p>
          </div>
        </div>

        <!-- Cardiology -->
        <div class="col-md-4">
          <div class="specialty-card">
            <i class="fas fa-heartbeat"></i>
            <h5>Cardiology</h5>
            <p>Advanced diagnosis, prevention, and treatment of heart diseases using cutting-edge technology and personalized care plans.</p>
          </div>
        </div>

        <!-- Dental -->
        <div class="col-md-4">
          <div class="specialty-card">
            <i class="fas fa-tooth"></i>
            <h5>Dental Department</h5>
            <p>Providing top-quality dental care, cosmetic dentistry, orthodontics, and oral surgery to keep your smile bright and healthy.</p>
          </div>
        </div>

        <!-- Pediatrics -->
        <div class="col-md-4">
          <div class="specialty-card">
            <i class="fas fa-baby"></i>
            <h5>Pediatrics</h5>
            <p>Dedicated healthcare for infants, children, and adolescents with a focus on growth, development, and preventive medicine.</p>
          </div>
        </div>

        <!-- Neurology -->
        <div class="col-md-4">
          <div class="specialty-card">
            <i class="fas fa-brain"></i>
            <h5>Neurology</h5>
            <p>Expert treatment of brain, spinal cord, and nervous system disorders using advanced diagnostics and therapies.</p>
          </div>
        </div>

        <!-- Radiology -->
        <div class="col-md-4">
          <div class="specialty-card">
            <i class="fas fa-x-ray"></i>
            <h5>Radiology</h5>
            <p>State-of-the-art imaging services including MRI, CT scans, and X-rays to support accurate diagnosis and treatment planning.</p>
          </div>
        </div>

        <!-- General Medicine -->
        <div class="col-md-4">
          <div class="specialty-card">
            <i class="fas fa-stethoscope"></i>
            <h5>General Medicine</h5>
            <p>Primary healthcare services for families and individuals, focusing on disease prevention, diagnosis, and treatment.</p>
          </div>
        </div>

      </div>
    </div>
  </section>

<!-- ================= Footer Section ================= -->
<footer class="bg-dark text-white pt-5 pb-4">
  <div class="container">
    <div class="row align-items-start">

      <!-- About / Logo -->
      <div class="col-md-4 mb-4 d-flex flex-column align-items-start">
        <div class="d-flex align-items-center mb-3">
          <img src="logo.png" alt="Ottohans Medical Center Logo" style="height:50px; margin-right:10px;">
          <h5 class="fw-bold mb-0">Ottohans Medical Center</h5>
        </div>
        <p>We provide top-notch healthcare services with professionalism, innovation, and compassion. Your health is our priority.</p>
      </div>

      <!-- Quick Links -->
      <div class="col-md-2 mb-4">
        <h5 class="fw-bold mb-3">Quick Links</h5>
        <ul class="list-unstyled">
          <li><a href="index.php#home" class="text-white text-decoration-none">Home</a></li>
          <li><a href="index.php#services" class="text-white text-decoration-none">Services</a></li>
          <li><a href="index.php#team" class="text-white text-decoration-none">Team</a></li>
          <li><a href="index.php#about" class="text-white text-decoration-none">About</a></li>
          <li><a href="specialties.php" class="text-white text-decoration-none">Specialties</a></li>
          <li><a href="contact.php" class="text-white text-decoration-none">Contact</a></li>
        </ul>
      </div>

      <!-- Contact Info -->
      <div class="col-md-3 mb-4">
        <h5 class="fw-bold mb-3">Contact Us</h5>
        <p class="mb-2"><i class="bi bi-geo-alt-fill me-2"></i><?php echo $row["address1"]; ?></p>

        <p class="mb-2"><i class="bi bi-geo-alt-fill me-2"></i><?php echo $row["address2"]; ?></p>

        <p class="mb-2"><i class="bi bi-telephone-fill me-2"></i><?php echo $row["phone1"]; ?></p>
        <p class="mb-2"><i class="bi bi-telephone-fill me-2"></i><?php echo $row["phone2"]; ?></p>
        <p class="mb-2"><i class="bi bi-envelope-fill me-2"></i><?php echo $row["email1"]; ?></p>
      </div>

      <!-- Social Media -->
      <div class="col-md-3 mb-4">
        <h5 class="fw-bold mb-3">Follow Us</h5>
        <div class="d-flex gap-3 fs-4">
          <a href="#" class="text-white"><i class="bi bi-facebook"></i></a>
          <a href="#" class="text-white"><i class="bi bi-twitter"></i></a>
          <a href="#" class="text-white"><i class="bi bi-linkedin"></i></a>
          <a href="#" class="text-white"><i class="bi bi-instagram"></i></a>
        </div>
      </div>
    </div>

    <hr class="bg-light">

    <!-- Copyright -->
    <div class="text-center pt-3">
      <p class="mb-0">&copy; 2025 Ottohans Medical Center. All Rights Reserved.</p>
    </div>
  </div>
</footer>

<!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '65d0d39bd9c01850ac614410835da1864214e5ef';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>


<!-- ================= Bootstrap Icons CDN ================= -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">


<!-- ================= Bootstrap Icons CDN ================= -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">


<!-- Font Awesome (for icons) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">


  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>