<?php
$pageName  = "Create Transactions";
include($_SERVER['DOCUMENT_ROOT'] . "/admin/layout/header.php");

// Handle form submission
if (isset($_POST['create_transaction'])) {
    $user_ids = $_POST['user_id'];
    $trans_types = $_POST['trans_type'];
    $amounts = $_POST['amount'];
    $created_ats = $_POST['created_at'];

    $stmt = $conn->prepare("INSERT INTO transactions (user_id, trans_type, amount, created_at) VALUES (:user_id, :trans_type, :amount, :created_at)");

    $successCount = 0;

    for ($i = 0; $i < count($user_ids); $i++) {
        $inserted = $stmt->execute([
            'user_id' => $user_ids[$i],
            'trans_type' => $trans_types[$i],
            'amount' => $amounts[$i],
            'created_at' => $created_ats[$i]
        ]);

        if ($inserted) {
            $successCount++;
        }
    }

    if ($successCount > 0) {
        echo "<div class='alert alert-success' style='position: fixed; z-index: 999; bottom: 20px; right: 10px;'>$successCount Transaction(s) created successfully.</div>";
    } else {
        echo "<div class='alert alert-danger'>No transactions were created.</div>";
    }
}

// Fetch users
$users = $conn->query("SELECT id, firstname, lastname FROM users ORDER BY firstname ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>Create Transactions</h1>
        <ol class="breadcrumb">
            <li><a href="./dashboard.php"><i class="fa fa-dashboard"></i> Dashboard</a></li>
        </ol>
    </section>

    <section class="content">
        <form method="POST">
            <div class="box box-default">
                <div class="box-body">
                    <div id="transaction-container">
                        <div class="transaction-group">
                            <hr>
                            <div class="form-group">
                                <label>Select User</label>
                                <select name="user_id[]" class="form-control" required>
                                    <option value="">-- Select User --</option>
                                    <?php foreach ($users as $user): ?>
                                        <option value="<?= $user['id'] ?>"><?= htmlspecialchars($user['firstname'] . ' ' . $user['lastname']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>Transaction Type</label>
                                <input type="text" name="trans_type[]" class="form-control" placeholder="e.g., Wire Transfer" required>
                            </div>

                            <div class="form-group">
                                <label>Amount</label>
                                <input type="number" name="amount[]" class="form-control" placeholder="Enter amount" required>
                            </div>

                            <div class="form-group">
                                <label>Transaction Date</label>
                                <input type="datetime-local" name="created_at[]" class="form-control" required>
                            </div>
                        </div>
                    </div>

                    <button type="button" class="btn btn-secondary" onclick="addTransaction()">Add Another</button>
                </div>

                <div class="box-footer">
                    <button type="submit" name="create_transaction" class="btn btn-primary">Submit All</button>
                </div>
            </div>
        </form>
    </section>
</div>

<script>
function addTransaction() {
    const container = document.getElementById('transaction-container');
    const firstGroup = container.querySelector('.transaction-group');
    const clone = firstGroup.cloneNode(true);

    // Reset values in the clone
    Array.from(clone.querySelectorAll('input, select')).forEach(input => input.value = '');

    container.appendChild(clone);
}
</script>

<?php include($_SERVER['DOCUMENT_ROOT'] . "/admin/layout/footer.php"); ?>
