<?php
session_start();
$pageName  = "Pincode";
include($_SERVER['DOCUMENT_ROOT'] . "/auth/header.php");

// Redirect if not logged in
if (!isset($_SESSION['login'])) {
    header("Location: ./login.php");
    exit;
}

// Redirect if already validated
if (isset($_SESSION['acct_no'])) {
    header("Location: ./user/dashboard.php");
    exit;
}

// Get user info
$viesConn = "SELECT * FROM users WHERE acct_no = :acct_no";
$stmt = $conn->prepare($viesConn);
$stmt->execute([':acct_no' => $_SESSION['login']]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) {
    session_destroy();
    header("Location: ./login.php");
    exit;
}

$user_id = $row['id'];
$fullName = $row['firstname'] . " " . $row['lastname'];
$acct_no = $row['acct_no'];
$to = $row['acct_email'];

// Handle resend OTP
if (isset($_POST['resend_otp'])) {
    $generatedOTP = rand(100000, 999999);
    $updateOtpQuery = "UPDATE users SET acct_otp = :otp WHERE id = :id";
    $updateStmt = $conn->prepare($updateOtpQuery);
    $updateStmt->execute([
        ':otp' => $generatedOTP,
        ':id' => $user_id
    ]);

    // Send OTP to email
    $subject = "Your Secure Login OTP";
    $message = "
        <html>
        <head><title>Your Secure Login OTP</title></head>
        <body>
          <p>Dear {$fullName},</p>
          <p>Your secure login OTP is: <strong>{$generatedOTP}</strong></p>
          <p>Do not share this code with anyone.</p>
          <p>Regards,<br>Your Bank Team</p>
        </body>
        </html>
    ";

    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8\r\n";
    $headers .= "From: noreply@fiwbinc.net\r\n";

    if (mail($to, $subject, $message, $headers)) {
        toast_alert('success', 'Your OTP has been sent to your email.');
    } else {
        toast_alert('error', 'Failed to send OTP email.');
    }
}

// Handle OTP verification
if (isset($_POST['pincode_submit'])) {
    $pincodeVerified = trim($_POST['input']);

    $otpCheck = $conn->prepare("SELECT acct_otp FROM users WHERE id = :id");
    $otpCheck->execute([':id' => $user_id]);
    $otpData = $otpCheck->fetch(PDO::FETCH_ASSOC);
    $validOtp = $otpData['acct_otp'];

    if (empty($pincodeVerified)) {
        toast_alert('error', 'Enter Your OTP');
    } elseif ($pincodeVerified != $validOtp) {
        toast_alert('error', 'Invalid OTP');
    } else {
        $_SESSION['acct_no'] = $acct_no;
        setcookie('firstVisit', $acct_no, time() + (86400 * 30), "/");
        header("Location: ./user/dashboard.php");
        exit;
    }
}
?>

<div class="authincation section-padding">
  <div class="container h-100">
    <div class="row justify-content-center h-100 align-items-center">
      <div class="col-xl-5 col-md-6">
        <div class="auth-form card">
          <div class="card-body">
            <center>
              <a href="/">
                <span class="thumb">
                  <img style="border-radius:10%;" src="<?= $web_url ?>/assets/user/profile/<?= $row['image'] ?>" alt="" width="30%" />
                </span>
              </a>
            </center>
          </div>
          <div class="card-body">
            <p class="mt-3 mb-0">Welcome back <?= htmlspecialchars($row['lastname']) . ' ' . htmlspecialchars($row['firstname']); ?></p>
            <p>Never give your Banking PIN, full password or card reader codes to anyone via text</p>
            <center><div id="google_translate_element"></div></center><br>

            <!-- OTP Verification Form -->
            <form method="post" class="signin_validate row g-3">
              <div class="col-12">
                <label class="form-label">Secured OTP</label>
                <input type="text" class="form-control" placeholder="OTP" name="input" required />
              </div>
              <div class="d-grid gap-2">
                <button type="submit" name="pincode_submit" class="btn btn-primary" style="background-color:#185250;">
                  Sign in Account
                </button>
              </div>
            </form>

            <!-- Resend OTP Button in separate form -->
            <form method="post" class="mt-3">
              <div class="d-grid gap-2">
                <button type="submit" name="resend_otp" class="btn btn-outline-secondary">
                  Send OTP
                </button>
              </div>
            </form>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include_once($_SERVER['DOCUMENT_ROOT'] . "/auth/footer.php"); ?>
