<?php
$pageName  = "Password Settings";
include($_SERVER['DOCUMENT_ROOT'] . "/user/layout/header.php");

// Ofofonobs Developer WhatsAPP +2348114313795


// Bank Script Developer - Use For Educational Purpose Only

// Other scripts Available

if (isset($_POST['change_password'])) {
    $old_password = inputValidation($_POST['old_password']);
    $new_password = inputValidation($_POST['new_password']);
    $confirm_password = inputValidation($_POST['confirm_password']);

    if (empty($old_password)) {
        toast_alert('danger', 'Enter Old Password', 'Close');
    } elseif (empty($new_password) || empty($confirm_password)) {
        toast_alert('danger', 'Enter New Password & Confirm Password', 'Close');
    } else {

        $new_password2 = password_hash((string)$new_password, PASSWORD_BCRYPT);
        $verification = password_verify($old_password, $row['acct_password']);

        if ($verification === false) {
            toast_alert("error", "Incorrect Old Password", "Close");
        } else if ($new_password !== $confirm_password) {
            toast_alert("error", "Confirm Password not matched", "Close");
        } else if ($new_password === $old_password) {
            toast_alert('error', 'New Password Matched with Old Password', 'Close');
        } else {
            $sql2 = "UPDATE users SET acct_password=:acct_password WHERE id =:id";
            $passwordUpdate = $conn->prepare($sql2);
            $passwordUpdate->execute([
                'acct_password' => $new_password2,
                'id' => $user_id
            ]);

            $full_name = $row['firstname'] . " " . $row['lastname'];
            $APP_NAME = WEB_TITLE;
            $APP_URL = WEB_URL;
            $SITE_ADDRESS = $page['url_address'];
            $user_email = $row['acct_email'];
            $user_acctno = $row['acct_no'];
            $message = $sendMail->PasswordMsg($full_name, $user_acctno, $APP_NAME, $APP_URL, $SITE_ADDRESS);
            // User Email
            $subject = "Password Change" . "-" . $APP_NAME;
            $email_message->send_mail($user_email, $message, $subject);

            if (true) {
                toast_alert('success', 'Your Password Change Successfully !', 'Approved');
            } else {
                toast_alert('error', 'Sorry Something Went Wrong');
            }
        }
    }
}

<div class="content-body">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="page-title">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-xl-4">
                            <div class="page-title-content">
                                <h3>Change Password</h3>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <div class="col-xxl-12 col-xl-12">
                <div class="row">


                    <div class="col-xl-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Hello <?= $fullName?> 
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <h5>What happens after you change your password</h5>
                                    <p>If you change or reset your password, you’ll be signed out everywhere except:<br>
                                    <ol>
                                        <li>Devices you use to verify that it's you when you sign in.</li>
                                        <li>Some devices with third-party apps that you've given account access.  </li>
                                        <li> Helpful devices that you've given account access.    </li>
                                        
                                    </ol>
                                
                                
                                </p>
                                <p>
                                If you're having trouble resetting your password, <a href="./support" >get more help</a>.
                                </p>
                                </div>
                            </div>
                        </div>
                    </div>

                   


                    <div class="col-xl-6 col-lg-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <form method="post">
                                        

                                        <input type="password" class="form-control mb-4" name="old_password" placeholder="Old Password" value="" required>

                                       
                                            <input type="text" class="form-control mb-4" name="new_password" placeholder="New Password" value="" required>
                                      
                                            <input type="text" class="form-control mb-4" name="confirm_password" placeholder="Confirm Password" required>
                                     

                                        <div class="col-auto">
                                            <button type="submit" name="change_password" class="btn btn-primary">Change Password</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    


                  


                </div>
            </div>

        </div>
    </div>
</div>


<?php 
include(__DIR__."/../user/layout/footer.php");

?>