<?php $__env->startSection('content'); ?>
    <div class="dashboard-inner">
        <div class="mb-4">
            <p><?php echo app('translator')->get('Loan'); ?></p>
            <div class="d-flex justify-content-between">
                <h3><?php echo e(__($pageTitle)); ?></h3>
                <a href="<?php echo e(route('user.loan.plans')); ?>" class="btn btn--base btn--sm"><i class="las la-hand-holding-usd"></i>
                    <?php echo app('translator')->get('Take Loan'); ?></a>
            </div>
        </div>
        <div class="row justify-content-center gy-4">
            <div class="col-lg-12">
                <div class="custom--card">

                    <div class="filter-area mb-3">
                        <div class="d-flex flex-wrap gap-4">
                            <div class="flex-grow-1">
                                <form action="">
                                    <div class="custom-input-box trx-search">
                                        <label><?php echo app('translator')->get('Loan Number'); ?></label>
                                        <input type="text" name="search" value="<?php echo e(request()->search); ?>"
                                            placeholder="<?php echo app('translator')->get('Search By Loan Number'); ?>">
                                        <button type="submit" class="icon-area">
                                            <i class="las la-search"></i>
                                        </button>
                                    </div>
                                </form>
                            </div>
                            <div class="flex-grow-1">
                                <div class="custom-input-box">
                                    <label><?php echo app('translator')->get('Loan Status'); ?></label>
                                    <select name="status" onChange="window.location.href=this.value">
                                        <option value=<?php echo e(queryLoanBuild('status', '')); ?>><?php echo app('translator')->get('All'); ?>
                                        </option>
                                        <option value="<?php echo e(queryLoanBuild('status', 0)); ?>" <?php if(request()->status != null && request()->status == 0): echo 'selected'; endif; ?>>
                                            <?php echo app('translator')->get('Pending'); ?></option>
                                        <option value="<?php echo e(queryLoanBuild('status', 1)); ?>" <?php if(request()->status == 1): echo 'selected'; endif; ?>>
                                            <?php echo app('translator')->get('Running'); ?></option>
                                        <option value="<?php echo e(queryLoanBuild('status', 2)); ?>" <?php if(request()->status == 2): echo 'selected'; endif; ?>>
                                            <?php echo app('translator')->get('Paid'); ?></option>
                                        <option value="<?php echo e(queryLoanBuild('status', 3)); ?>" <?php if(request()->status == 3): echo 'selected'; endif; ?>>
                                            <?php echo app('translator')->get('Rejected'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="accordion table--acordion" id="transactionAccordion">
                        <?php $__empty_1 = true; $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="accordion-item transaction-item" title="<?php echo app('translator')->get('Click For Details'); ?>">
                                <h2 class="accordion-header" id="h-<?php echo e($loop->iteration); ?>">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#c-<?php echo e($loop->iteration); ?>">
                                        <div class="col-lg-3 col-sm-5 col-8 order-1 icon-wrapper">
                                            <div class="left">
                                                <?php if($loan->status == Status::LOAN_PENDING): ?>
                                                    <div class="icon icon-dark">
                                                        <i class="las la-sync"></i>
                                                    </div>
                                                <?php elseif($loan->status == Status::LOAN_RUNNING): ?>
                                                    <div class="icon icon-primary">
                                                        <i class="las la-spinner fa-spin"></i>
                                                    </div>
                                                <?php elseif($loan->status == Status::LOAN_PAID): ?>
                                                    <div class="icon icon-success">
                                                        <i class="las la-check-circle"></i>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="icon icon-danger">
                                                        <i class="las la-ban"></i>
                                                    </div>
                                                <?php endif; ?>

                                                <div class="content">
                                                    <h6 class="trans-title" title="<?php echo app('translator')->get('Loan Plan'); ?>">
                                                        <?php echo e(__($loan->plan->name)); ?></h6>
                                                    <span
                                                        class="text-muted font-size--14px mt-2"><?php echo e(showDateTime($loan->created_at, 'M d Y @g:i:a')); ?></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-3 col-sm-4 col-12 order-sm-2 order-2 content-wrapper mt-sm-0 mt-3"
                                            title="<?php echo app('translator')->get('Loan Number'); ?>">
                                            <p class="text-muted font-size--14px"><b><?php echo e($loan->loan_number); ?></b></p>
                                        </div>
                                        <div class="col-lg-3 col-sm-4 col-12 order-sm-2 order-3 content-wrapper mt-sm-0 mt-3"
                                            title="<?php echo app('translator')->get('Status'); ?>">
                                            <p class="text-muted font-size--14px">
                                                <?php echo $loan->statusBadge; ?>
                                            </p>
                                        </div>

                                        <div class="col-lg-3 col-sm-3 col-4 order-sm-3 order-4 text-end amount-wrapper">
                                            <p>
                                                <b><?php echo e(showAmount($loan->amount)); ?> <?php echo e($general->cur_text); ?></b><br>
                                                <small class="text--base">
                                                    <?php echo e($general->cur_sym . showAmount($loan->payable_amount)); ?>

                                                    <small>(<?php echo app('translator')->get('Need to pay'); ?>)</small>
                                                </small>
                                            </p>

                                        </div>
                                    </button>
                                </h2>
                                <div id="c-<?php echo e($loop->iteration); ?>" class="accordion-collapse collapse"
                                    aria-labelledby="h-1" data-bs-parent="#transactionAccordion">
                                    <div class="accordion-body">
                                        <ul class="caption-list">
                                            <li>
                                                <span class="caption"><?php echo app('translator')->get('Installment Amount'); ?></span>
                                                <div class="value">
                                                    <span><?php echo e($general->cur_sym . showAmount($loan->per_installment)); ?></span>
                                                    <br>
                                                    <small class="text--base">
                                                        <?php echo app('translator')->get('In Every'); ?> <?php echo e(__($loan->installment_interval)); ?>

                                                        <?php echo app('translator')->get('Days'); ?>
                                                    </small>
                                                </div>
                                            </li>
                                            <li>
                                                <span class="caption"><?php echo app('translator')->get('Installment'); ?></span>
                                                <div class="value">
                                                    <span> <?php echo app('translator')->get('Total'); ?> : <?php echo e(__($loan->total_installment)); ?></span>
                                                    <br>
                                                    <small class="text--base">
                                                        <?php echo app('translator')->get('Given'); ?> : <?php echo e(__($loan->given_installment)); ?>

                                                    </small>
                                                </div>
                                            </li>
                                            <li>
                                                <span class="caption"><?php echo app('translator')->get('Next Installment'); ?></span>
                                                <div class="value">
                                                    <?php if($loan->nextInstallment): ?>
                                                        <?php echo e(showDateTime($loan->nextInstallment->installment_date, 'd M, Y')); ?>

                                                    <?php endif; ?>
                                                </div>
                                            </li>
                                            <li>
                                                <span class="caption"><?php echo app('translator')->get('Paid'); ?></span>
                                                <span class="value">
                                                    <span><?php echo e($general->cur_sym . showAmount($loan->paid_amount)); ?></span>
                                                    <br>
                                                    <span class="text--warning">
                                                        <?php $remainingAmount = $loan->payableAmount - $loan->paid_amount;  ?>
                                                        <small> <?php echo e($general->cur_sym . showAmount($remainingAmount)); ?>

                                                            <small> <?php echo app('translator')->get('Remaining'); ?></small></small>
                                                    </span>
                                                </span>
                                            </li>
                                            <li>
                                                <span class="caption"><?php echo app('translator')->get('Status'); ?></span>
                                                <div class="value">
                                                    <?php echo $loan->statusBadge; ?>
                                                    <?php if($loan->status == Status::LOAN_REJECTED): ?>
                                                        <span class="admin-feedback"
                                                            data-feedback="<?php echo e(__($loan->admin_feedback)); ?>">
                                                            <i class="las la-info-circle"></i>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </li>
                                            <li>
                                                <span class="caption"><?php echo app('translator')->get('Action'); ?></span>
                                                <div class="value">
                                                    <a class="btn btn--outline-primary btn--sm <?php if(!$loan->nextInstallment): echo 'disabled'; endif; ?>"
                                                        href="<?php echo e(route('user.loan.instalment.logs', $loan->loan_number)); ?>">
                                                        <i class="las la-wallet"></i> <?php echo app('translator')->get('Installments'); ?>
                                                    </a>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div><!-- transaction-item end -->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="accordion-body text-center">
                                <h4 class="text--muted"><?php echo e(__($emptyMessage)); ?></h4>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if($loans->hasPages()): ?>
                        <div class="card-footer py-2">
                            <?php echo e(paginateLinks($loans)); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="adminFeedback">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Reason of Rejection'); ?>!</h5>
                </div>
                <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button class="btn btn-sm btn--dark" data-bs-dismiss="modal"
                        type="button"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .trx-search {
            position: relative;
        }

        .trx-search .icon-area {
            position: absolute;
            top: 10px;
            right: 8px;
            font-size: 20px;
            background: transparent;
            border: none;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.admin-feedback').on('click', function() {
                var modal = $('#adminFeedback');
                modal.find('.modal-body').text($(this).data('feedback'));
                modal.modal('show');
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ultimatx/public_html/eleonagroupintl.com/core/resources/views/templates/basic/user/loan/list.blade.php ENDPATH**/ ?>