<?php
    $policyPages = getContent('policy_pages.element', false, null, true);
    $loginContent = getContent('login.content', true);
?>


<?php $__env->startSection('content'); ?>
    <div class="section container">
        <div class="row g-lg-0">
            <div class="col-lg-6 d-none d-lg-block">
                <div class="h-100 auth-form__bg"
                     style="background-image: url(<?php echo e(getImage('assets/images/frontend/login/' . @$loginContent->data_values->image, '800x1100')); ?>);">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="auth-form__content">
                    <h3 class="text-capitalize text-center mt-0 mb-4">
                        <?php echo app('translator')->get('Welcome To'); ?> <?php echo e(__($general->site_name)); ?>

                    </h3>
                    <form method="POST" action="<?php echo e(route('user.register')); ?>" class="row g-4">
                        <?php echo csrf_field(); ?>
                        <div class="col-12">
                            <div class="auth-form__input-group">
                                <span class="auth-form__input-icon">
                                    <i class="la la-user"></i>
                                </span>
                                <input type="text" name="username" class="auth-form__input checkUser"
                                       value="<?php echo e(old('username')); ?>" placeholder="<?php echo app('translator')->get('Username'); ?>" required
                                       autofocus="off"/>
                            </div>
                            <small class="text--danger usernameExist"></small>
                        </div>

                        <div class="col-12">
                            <div class="auth-form__input-group">
                                <span class="auth-form__input-icon">
                                    <i class="las la-envelope-open-text"></i>
                                </span>
                                <input type="text" name="email" class="auth-form__input checkUser"
                                       value="<?php echo e(old('email')); ?>" placeholder="<?php echo app('translator')->get('Email Address'); ?>" required
                                       autofocus="off"/>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="custom--nice-select auth-form__input-group">
                                <span class="auth-form__input-icon">
                                    <i class="la la-globe-asia"></i>
                                </span>
                                <select name="country">
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-mobile_code="<?php echo e($country->dial_code); ?>"
                                                value="<?php echo e($country->country); ?>" data-code="<?php echo e($key); ?>">
                                            <?php echo e(__($country->country)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="auth-form__input-group">
                                <span class="auth-form__input-icon mobile-code"></span>
                                <input type="hidden" name="mobile_code">
                                <input type="hidden" name="country_code">
                                <input type="number" name="mobile" class="auth-form__input checkUser"
                                       value="<?php echo e(old('mobile')); ?>" placeholder="<?php echo app('translator')->get('Your Mobile Number'); ?>" required
                                       autofocus="off"/>
                            </div>
                            <small class="text--danger mobileExist"></small>
                        </div>

                        <div class="col-12">
                            <div class="auth-form__input-group form-group">
                                <span class="auth-form__input-icon">
                                    <i class="las la-lock"></i>
                                </span>
                                <input type="password" name="password"
                                       class="auth-form__input <?php if($general->secure_password): ?> secure-password <?php endif; ?>"
                                       placeholder="<?php echo app('translator')->get('Your password'); ?>" required/>
                                <span class="auth-form__input-icon auth-form__toggle-pass">
                                    <i class="bx bxs-hide"></i>
                                </span>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="auth-form__input-group">
                                <span class="auth-form__input-icon">
                                    <i class="las la-lock"></i>
                                </span>
                                <input type="password" name="password_confirmation" class="auth-form__input"
                                       placeholder="<?php echo app('translator')->get('Confirm password'); ?>" required/>
                                <span class="auth-form__input-icon auth-form__toggle-pass">
                                    <i class="bx bxs-hide"></i>
                                </span>
                            </div>
                        </div>

                        

                        <?php if($general->agree): ?>
                            <div class="form-group">
                                <input type="checkbox" id="agree" <?php if(old('agree')): echo 'checked'; endif; ?> name="agree" required>
                                <label for="agree"><?php echo app('translator')->get('I agree with'); ?></label>
                                <span>
                                    <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a class="text-decoration-none"
                                           href="<?php echo e(route('policy.pages', [slug($policy->data_values->title), $policy->id])); ?>"
                                           target="_blank"><?php echo e(__($policy->data_values->title)); ?></a>
                                        <?php if(!$loop->last): ?>, <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </span>
                            </div>
                        <?php endif; ?>

                        <div class="col-12">
                            <button type="submit" class="btn btn--base btn--xxl w-100 text-capitalize xl-text">
                                <?php echo app('translator')->get('Register'); ?>
                            </button>
                        </div>

                        <div class="col-12">
                            <p class="mb-0 text-capitalize text-center">
                                <?php echo app('translator')->get('Already have an account yet'); ?>?
                                <a href="<?php echo e(route('user.login')); ?>"
                                   class="t-link border-0 bg--light btn-link t-link--primary">
                                    <?php echo app('translator')->get('Login Now'); ?>
                                </a>
                            </p>
                        </div>

                        <?php
                            $credentials = $general->socialite_credentials;
                        ?>
                        <?php if($credentials->google->status == Status::ENABLE || $credentials->facebook->status == Status::ENABLE || $credentials->linkedin->status == Status::ENABLE): ?>
                            <div class="col-12">
                                <div class="auth-form__divider">
                                    <span class="d-block text-center text-capitalize auth-form__divider-text">
                                        <?php echo app('translator')->get(' or'); ?>
                                    </span>
                                </div>
                            </div>
                            <div class="col-12">
                                <p class="mb-0 text-capitalize text-center">
                                    <?php echo app('translator')->get('Continue with social media'); ?>
                                </p>
                            </div>
                            <div class="col-12">
                                <ul class="list list--row justify-content-center">
                                    <?php if($credentials->facebook->status == Status::ENABLE): ?>
                                        <li class="list--row__item">
                                            <a href="<?php echo e(route('user.social.login', 'facebook')); ?>"
                                               class="t-link icon icon--circle icon--md bg--primary t-text-white t-link--light">
                                                <i class="bx bxl-facebook"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($credentials->google->status == Status::ENABLE): ?>
                                        <li class="list--row__item">
                                            <a href="<?php echo e(route('user.social.login', 'google')); ?>"
                                               class="t-link icon icon--circle icon--md bg--danger t-text-white t-link--light">
                                                <i class="bx bxl-google"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($credentials->linkedin->status == Status::ENABLE): ?>
                                        <li class="list--row__item">
                                            <a href="<?php echo e(route('user.social.login', 'linkedin')); ?>"
                                               class="t-link icon icon--circle icon--md bg--info t-text-white t-link--light">
                                                <i class="bx bxl-linkedin"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog"
         aria-labelledby="existModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="existModalLongTitle"><?php echo app('translator')->get('You are with us'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <h6 class="text-center"><?php echo app('translator')->get('You already have an account please Login '); ?></h6>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn-sm" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <a href="<?php echo e(route('user.login')); ?>" class="btn btn--base btn-sm"><?php echo app('translator')->get('Login'); ?></a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php if($general->secure_password): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            <?php if($mobileCode): ?>
            $(`option[data-code=<?php echo e($mobileCode); ?>]`).attr('selected', '');
            <?php endif; ?>

            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            });
            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));

            $('.checkUser').on('focusout', function(e) {
                var url = '<?php echo e(route('user.checkUser')); ?>';
                var value = $(this).val();
                var token = '<?php echo e(csrf_token()); ?>';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {mobile: mobile, _token: token}
                }
                if ($(this).attr('name') == 'email') {
                    var data = {email: value, _token: token}
                }
                if ($(this).attr('name') == 'username') {
                    var data = {username: value, _token: token}
                }
                $.post(url, data, function(response) {
                    if (response.data != false && response.type == 'email') {
                        $('#existModalCenter').modal('show');
                    } else if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.type} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ultimatx/public_html/eleonagroupintl.com/core/resources/views/templates/basic/user/auth/register.blade.php ENDPATH**/ ?>