<?php
    $faqContent = getContent('faq.content', true);
    $faqElement = getContent('faq.element', orderById: true);
?>

<section class="section--sm section--bottom">
    <div class="section__head">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-xl-8">
                    <div class="text-center">
                        <div class="d-flex align-items-center justify-content-center">
                            
                            <p class="mb-0 text-capitalize text--primary xxl-text">
                                <?php echo e(__(@$faqContent->data_values->subheading)); ?></p>
                        </div>
                        <h2 class="text-capitalize"><?php echo e(__(@$faqContent->data_values->heading)); ?></h2>
                        <p class="t-short-para mx-auto mb-0">
                            <?php echo e(__(@$faqContent->data_values->description)); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row justify-content-center g-4">
            <div class="col-lg-10 col-xl-8">
                <div class="accordion vf-accordion" id="faqAccordion">
                    <?php $__currentLoopData = $faqElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="accordion-item vf-accordion__item">
                            <h2 class="accordion-header vf-accordion__header">
                                <button class="accordion-button vf-accordion__btn <?php echo e(!$loop->first ? 'collapsed' : null); ?>" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo e($faq->id); ?>"
                                    aria-expanded="<?php echo e(!$loop->first ? 'false' : 'true'); ?>">
                                    <?php echo e(__($faq->data_values->question)); ?>

                                </button>
                            </h2>
                            <div id="collapse-<?php echo e($faq->id); ?>" class="accordion-collapse collapse <?php echo e($loop->first ? 'show' : null); ?>"
                                data-bs-parent="#faqAccordion">
                                <div class="accordion-body vf-accordion__body">
                                    <?php
                                        echo $faq->data_values->answer;
                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/ultimatx/public_html/eleonagroupintl.com/core/resources/views/templates/basic/sections/faq.blade.php ENDPATH**/ ?>